/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.floo;

import dev.aaronhowser.mods.irregular_implements.IrregularImplements;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.FlooBrickBlockEntity;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooFireplace;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.utils.Levenshtein;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooNetworkSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "fireplaces", "", "Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooFireplace;", "getFireplaces", "", "addFireplace", "", "fireplace", "masterUuid", "Ljava/util/UUID;", "name", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "createFireplace", "", "connectedBricks", "findFireplace", "flooBrickBlockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity;", "uuid", "removeFireplace", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFlooNetworkSavedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlooNetworkSavedData.kt\ndev/aaronhowser/mods/irregular_implements/handler/floo/FlooNetworkSavedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n774#2:117\n865#2,2:118\n1563#2:120\n1634#2,3:121\n774#2:124\n865#2,2:125\n2423#2,14:127\n295#2,2:141\n295#2,2:143\n*S KotlinDebug\n*F\n+ 1 FlooNetworkSavedData.kt\ndev/aaronhowser/mods/irregular_implements/handler/floo/FlooNetworkSavedData\n*L\n49#1:117\n49#1:118,2\n53#1:120\n53#1:121,3\n54#1:124\n54#1:125,2\n55#1:127,14\n65#1:141,2\n69#1:143,2\n*E\n"})
public final class FlooNetworkSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FlooFireplace> fireplaces = new ArrayList();
    @NotNull
    public static final String NBT_FIREPLACES = "Fireplaces";
    @NotNull
    public static final String SAVED_DATA_NAME = "ii_floo_network";
    @NotNull
    public static final String OLD_SAVED_DATA_NAME = "floo_network";

    @NotNull
    public final List<FlooFireplace> getFireplaces() {
        return CollectionsKt.toList((Iterable)this.fireplaces);
    }

    public final void addFireplace(@NotNull FlooFireplace fireplace) {
        Intrinsics.checkNotNullParameter((Object)fireplace, (String)"fireplace");
        this.fireplaces.add(fireplace);
        this.setDirty();
    }

    public final void addFireplace(@NotNull UUID masterUuid, @Nullable String name, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)masterUuid, (String)"masterUuid");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.addFireplace(new FlooFireplace(masterUuid, name, blockPos));
    }

    public final boolean createFireplace(@NotNull UUID masterUuid, @Nullable String name, @NotNull BlockPos blockPos, @NotNull List<? extends BlockPos> connectedBricks) {
        Intrinsics.checkNotNullParameter((Object)masterUuid, (String)"masterUuid");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(connectedBricks, (String)"connectedBricks");
        for (FlooFireplace fireplace : this.fireplaces) {
            if (connectedBricks.contains(fireplace.getMasterBlockPos())) {
                return false;
            }
            String theirName = fireplace.getName();
            if (theirName == null || !StringsKt.equals((String)theirName, (String)name, (boolean)true)) continue;
            return false;
        }
        this.addFireplace(masterUuid, name, blockPos);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FlooFireplace findFireplace(@NotNull String name) {
        Object v4;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv2 = this.fireplaces;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Iterator it2 = (FlooFireplace)element$iv$iv;
            boolean bl = false;
            object = ((FlooFireplace)((Object)it2)).getName();
            if (!(!(object == null || StringsKt.isBlank((CharSequence)object)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fireplacesWithNames = (List)destination$iv$iv;
        Integer maxDistance = (Integer)ServerConfig.Companion.getCONFIG().getFlooNameMaxDistance().get();
        Iterable $this$map$iv = fireplacesWithNames;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (FlooFireplace)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            String string3 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(TuplesKt.to((Object)it, (Object)Levenshtein.distance((CharSequence)charSequence, (CharSequence)string3)));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() <= maxDistance)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                Pair it3 = (Pair)minElem$iv;
                boolean bl = false;
                int minValue$iv = ((Number)it3.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it4 = (Pair)e$iv;
                    $i$a$-minByOrNull-FlooNetworkSavedData$findFireplace$nearest$3 = false;
                    int v$iv = ((Number)it4.getSecond()).intValue();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        Pair nearest = v4;
        if (nearest != null) {
            IrregularImplements.LOGGER.debug("Floo Fireplace found by name '" + name + "': '" + ((FlooFireplace)nearest.getFirst()).getName() + "' with distance " + nearest.getSecond());
        }
        Pair pair = nearest;
        return pair != null ? (FlooFireplace)pair.getFirst() : null;
    }

    @Nullable
    public final FlooFireplace findFireplace(@NotNull FlooBrickBlockEntity flooBrickBlockEntity) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)flooBrickBlockEntity), (String)"flooBrickBlockEntity");
            Iterable $this$firstOrNull$iv = this.fireplaces;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FlooFireplace it = (FlooFireplace)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getMasterUuid(), (Object)flooBrickBlockEntity.getUuid()) || Intrinsics.areEqual((Object)it.getMasterUuid(), (Object)flooBrickBlockEntity.getMasterUUID()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final FlooFireplace findFireplace(@NotNull UUID uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable $this$firstOrNull$iv = this.fireplaces;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FlooFireplace it = (FlooFireplace)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMasterUuid(), (Object)uuid)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void removeFireplace(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.fireplaces.removeIf(arg_0 -> FlooNetworkSavedData.removeFireplace$lambda$7(arg_0 -> FlooNetworkSavedData.removeFireplace$lambda$6(uuid, arg_0), arg_0));
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag fireplaceList = tag.getList(NBT_FIREPLACES, 9);
        for (FlooFireplace fireplace : this.fireplaces) {
            fireplaceList.add((Object)fireplace.toTag());
        }
        tag.put(NBT_FIREPLACES, (Tag)fireplaceList);
        return tag;
    }

    private static final boolean removeFireplace$lambda$6(UUID $uuid, FlooFireplace it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getMasterUuid(), (Object)$uuid);
    }

    private static final boolean removeFireplace$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooNetworkSavedData$Companion;", "", "<init>", "()V", "NBT_FIREPLACES", "", "SAVED_DATA_NAME", "OLD_SAVED_DATA_NAME", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooNetworkSavedData;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final FlooNetworkSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
            FlooNetworkSavedData data = new FlooNetworkSavedData();
            ListTag fireplaceList = tag.getList(FlooNetworkSavedData.NBT_FIREPLACES, 10);
            int n = ((Collection)fireplaceList).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag fireplaceTag = fireplaceList.getCompound(i);
                List list = data.fireplaces;
                Intrinsics.checkNotNull((Object)fireplaceTag);
                list.add(FlooFireplace.Companion.fromTag(fireplaceTag));
            }
            return data;
        }

        @NotNull
        public final FlooNetworkSavedData get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            DimensionDataStorage storage = level.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(FlooNetworkSavedData::new, this::load);
            Intrinsics.checkNotNull((Object)storage);
            Object t = OtherUtil.INSTANCE.updateSavedDataLocation(storage, factory, FlooNetworkSavedData.SAVED_DATA_NAME, FlooNetworkSavedData.OLD_SAVED_DATA_NAME);
            Intrinsics.checkNotNullExpressionValue(t, (String)"updateSavedDataLocation(...)");
            return (FlooNetworkSavedData)((Object)t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

