/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.item.component.BiomePointsDataComponent;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomeCapsuleItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "onEntityItemUpdate", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "entity", "Lnet/minecraft/world/entity/item/ItemEntity;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class BiomeCapsuleItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BiomeCapsuleItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack stack, @NotNull ItemEntity entity) {
        BiomePointsDataComponent component;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockPos onBlockPos = entity.getBlockPosBelowThatAffectsMyMovement();
        if (entity.level().getBlockState(onBlockPos).isAir()) {
            return super.onEntityItemUpdate(stack, entity);
        }
        Holder biome = entity.level().getBiome(onBlockPos);
        BiomePointsDataComponent biomePointsDataComponent = (BiomePointsDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS());
        if (biomePointsDataComponent == null) {
            Intrinsics.checkNotNull((Object)biome);
            biomePointsDataComponent = new BiomePointsDataComponent((Holder<Biome>)biome, 0);
        }
        if (!Intrinsics.areEqual((component = biomePointsDataComponent).getBiome(), (Object)biome)) {
            return super.onEntityItemUpdate(stack, entity);
        }
        stack.set((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS(), (Object)component.withMorePoints(1));
        return super.onEntityItemUpdate(stack, entity);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        BiomePointsDataComponent biomePointsDataComponent = (BiomePointsDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS());
        if (biomePointsDataComponent == null) {
            return;
        }
        BiomePointsDataComponent biomePointsComponent = biomePointsDataComponent;
        Component biomeComponent = OtherUtil.INSTANCE.getBiomeComponent(biomePointsComponent.getBiome());
        int biomePoints = biomePointsComponent.getPoints();
        tooltipComponents.add(biomeComponent);
        tooltipComponents.add((Component)ModLanguageProvider.Companion.toComponent(String.valueOf(biomePoints), new Object[0]));
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\"\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomeCapsuleItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "getItemColor", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "tintIndex", "getFirstNonEmptyCapsule", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "excludeBiome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "getBiomeToPaint", "player", "Lnet/minecraft/world/entity/player/Player;", "getFirstCapsuleWithBiome", "biome", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final int getItemColor(@NotNull ItemStack stack, int tintIndex) {
            Biome biome;
            Holder<Biome> holder;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            BiomePointsDataComponent biomePointsDataComponent = (BiomePointsDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS());
            int foliageColor = biomePointsDataComponent != null && (holder = biomePointsDataComponent.getBiome()) != null && (biome = (Biome)holder.value()) != null ? biome.getFoliageColor() : -1;
            return foliageColor | 0xFF000000;
        }

        @Nullable
        public final ItemStack getFirstNonEmptyCapsule(@NotNull Inventory playerInventory, @Nullable Holder<Biome> excludeBiome) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            NonNullList stacks = playerInventory.items;
            Iterator iterator = stacks.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                BiomePointsDataComponent component;
                ItemStack stack = (ItemStack)iterator2.next();
                if ((BiomePointsDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS()) == null || component.getPoints() <= 0 || Intrinsics.areEqual(component.getBiome(), excludeBiome)) continue;
                return stack;
            }
            return null;
        }

        public static /* synthetic */ ItemStack getFirstNonEmptyCapsule$default(Companion companion, Inventory inventory, Holder holder, int n, Object object) {
            if ((n & 2) != 0) {
                holder = null;
            }
            return companion.getFirstNonEmptyCapsule(inventory, (Holder<Biome>)holder);
        }

        @Nullable
        public final Holder<Biome> getBiomeToPaint(@NotNull Player player) {
            BiomePointsDataComponent biomePointsDataComponent;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Inventory inventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
            ItemStack itemStack = dev.aaronhowser.mods.irregular_implements.item.BiomeCapsuleItem$Companion.getFirstNonEmptyCapsule$default(this, inventory, null, 2, null);
            return itemStack != null && (biomePointsDataComponent = (BiomePointsDataComponent)itemStack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS())) != null ? biomePointsDataComponent.getBiome() : null;
        }

        @Nullable
        public final ItemStack getFirstCapsuleWithBiome(@NotNull Inventory playerInventory, @NotNull Holder<Biome> biome) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter(biome, (String)"biome");
            NonNullList stacks = playerInventory.items;
            Iterator iterator = stacks.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                BiomePointsDataComponent component;
                ItemStack stack = (ItemStack)iterator2.next();
                if ((BiomePointsDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS()) == null || component.getPoints() <= 0 || !Intrinsics.areEqual(component.getBiome(), biome)) continue;
                return stack;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

