/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import com.mojang.datafixers.util.Either;
import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.client.render.BiomePainterRenderer;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.item.BiomeCapsuleItem;
import dev.aaronhowser.mods.irregular_implements.item.component.BiomePointsDataComponent;
import dev.aaronhowser.mods.irregular_implements.packet.client_to_server.PaintBiomePacket;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomePainterItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "inventoryTick", "", "stack", "entity", "Lnet/minecraft/world/entity/Entity;", "slotId", "", "isSelected", "", "Companion", "Positions", "irregular-implements-1.21.1"})
public final class BiomePainterItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BiomePainterItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            Holder<Biome> holder = BiomeCapsuleItem.Companion.getBiomeToPaint(player);
            if (holder == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            Holder<Biome> biomeToPaint = holder;
            ResourceKey resourceKey = biomeToPaint.getKey();
            if (resourceKey == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            ResourceKey biomeRk = resourceKey;
            Positions positions = Positions.Companion.getPositions(player, biomeToPaint);
            BlockPos blockPos = positions.getTargetedUnmatchingPosition();
            if (blockPos == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            BlockPos targetPos = blockPos;
            PaintBiomePacket packet = new PaintBiomePacket(targetPos, (ResourceKey<Biome>)biomeRk);
            packet.messageServer();
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (isSelected && level.isClientSide) {
            BiomePainterRenderer.INSTANCE.indicatePositions(entity);
        }
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomePainterItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "handlePacket", "", "packet", "Ldev/aaronhowser/mods/irregular_implements/packet/client_to_server/PaintBiomePacket;", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final void handlePacket(@NotNull PaintBiomePacket packet, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)packet), (String)"packet");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player player = context.player();
            ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
            if (serverPlayer == null) {
                return;
            }
            ServerPlayer player2 = serverPlayer;
            ServerLevel level = player2.serverLevel();
            BlockPos blockPos = packet.getBlockPos();
            ResourceKey<Biome> biomeRk = packet.getBiomeRk();
            Optional optional = level.registryAccess().registryOrThrow(Registries.BIOME).getHolder(biomeRk);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getHolder(...)");
            Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
            if (reference == null) {
                return;
            }
            Holder.Reference biomeToPlace = reference;
            Inventory inventory = player2.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
            ItemStack itemStack = BiomeCapsuleItem.Companion.getFirstCapsuleWithBiome(inventory, (Holder<Biome>)((Holder)biomeToPlace));
            if (itemStack == null) {
                return;
            }
            ItemStack firstCapsule = itemStack;
            BiomePointsDataComponent biomePointsDataComponent = (BiomePointsDataComponent)firstCapsule.get((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS());
            if (biomePointsDataComponent == null) {
                return;
            }
            BiomePointsDataComponent component = biomePointsDataComponent;
            Ref.IntRef points = new Ref.IntRef();
            points.element = player2.hasInfiniteMaterials() ? 9999 : component.getPoints();
            Integer radius = (Integer)ServerConfig.Companion.getCONFIG().getBiomePainterRadius().get();
            BlockPos blockPos2 = blockPos.offset(-radius.intValue(), -radius.intValue(), -radius.intValue());
            Intrinsics.checkNotNull((Object)radius);
            Either result = FillBiomeCommand.fill((ServerLevel)level, (BlockPos)blockPos2, (BlockPos)blockPos.offset(radius.intValue(), radius.intValue(), radius.intValue()), (Holder)((Holder)biomeToPlace), arg_0 -> Companion.handlePacket$lambda$0(biomeToPlace, points, arg_0), Companion::handlePacket$lambda$1);
            Integer amountChanged = result.left().orElse(0);
            if (!player2.hasInfiniteMaterials()) {
                if (amountChanged < points.element) {
                    Supplier supplier = (Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS();
                    Intrinsics.checkNotNull((Object)amountChanged);
                    v8 = (BiomePointsDataComponent)firstCapsule.set(supplier, (Object)component.withLessPoints(amountChanged));
                } else {
                    v8 = (BiomePointsDataComponent)firstCapsule.remove((Supplier)ModDataComponents.INSTANCE.getBIOME_POINTS());
                }
            }
            Object[] objectArray = new Object[]{amountChanged, OtherUtil.INSTANCE.getBiomeComponent((Holder<Biome>)((Holder)biomeToPlace))};
            AaronExtensions.INSTANCE.status((Player)player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.biome_painter.amount_changed", objectArray));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean handlePacket$lambda$0(Holder.Reference $biomeToPlace, Ref.IntRef $points, Holder biomeThere) {
            if (Intrinsics.areEqual((Object)biomeThere, (Object)$biomeToPlace)) return false;
            int n = $points.element;
            $points.element = n + -1;
            if (n <= 0) return false;
            return true;
        }

        private static final void handlePacket$lambda$1(Supplier supplier) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomePainterItem$Positions;", "", "matchingPositions", "", "Lnet/minecraft/core/BlockPos;", "unmatchingPositions", "targetedUnmatchingPosition", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lnet/minecraft/core/BlockPos;)V", "getMatchingPositions", "()Ljava/util/Set;", "getUnmatchingPositions", "getTargetedUnmatchingPosition", "()Lnet/minecraft/core/BlockPos;", "untargetedUnmatchingPositions", "getUntargetedUnmatchingPositions", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "irregular-implements-1.21.1"})
    public static final class Positions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<BlockPos> matchingPositions;
        @NotNull
        private final Set<BlockPos> unmatchingPositions;
        @Nullable
        private final BlockPos targetedUnmatchingPosition;
        @NotNull
        private final Set<BlockPos> untargetedUnmatchingPositions;

        public Positions(@NotNull Set<? extends BlockPos> matchingPositions, @NotNull Set<? extends BlockPos> unmatchingPositions, @Nullable BlockPos targetedUnmatchingPosition) {
            Intrinsics.checkNotNullParameter(matchingPositions, (String)"matchingPositions");
            Intrinsics.checkNotNullParameter(unmatchingPositions, (String)"unmatchingPositions");
            this.matchingPositions = matchingPositions;
            this.unmatchingPositions = unmatchingPositions;
            this.targetedUnmatchingPosition = targetedUnmatchingPosition;
            this.untargetedUnmatchingPositions = this.targetedUnmatchingPosition != null ? SetsKt.minus(this.unmatchingPositions, (Object)this.targetedUnmatchingPosition) : this.unmatchingPositions;
        }

        @NotNull
        public final Set<BlockPos> getMatchingPositions() {
            return this.matchingPositions;
        }

        @NotNull
        public final Set<BlockPos> getUnmatchingPositions() {
            return this.unmatchingPositions;
        }

        @Nullable
        public final BlockPos getTargetedUnmatchingPosition() {
            return this.targetedUnmatchingPosition;
        }

        @NotNull
        public final Set<BlockPos> getUntargetedUnmatchingPositions() {
            return this.untargetedUnmatchingPositions;
        }

        @NotNull
        public final Set<BlockPos> component1() {
            return this.matchingPositions;
        }

        @NotNull
        public final Set<BlockPos> component2() {
            return this.unmatchingPositions;
        }

        @Nullable
        public final BlockPos component3() {
            return this.targetedUnmatchingPosition;
        }

        @NotNull
        public final Positions copy(@NotNull Set<? extends BlockPos> matchingPositions, @NotNull Set<? extends BlockPos> unmatchingPositions, @Nullable BlockPos targetedUnmatchingPosition) {
            Intrinsics.checkNotNullParameter(matchingPositions, (String)"matchingPositions");
            Intrinsics.checkNotNullParameter(unmatchingPositions, (String)"unmatchingPositions");
            return new Positions(matchingPositions, unmatchingPositions, targetedUnmatchingPosition);
        }

        public static /* synthetic */ Positions copy$default(Positions positions, Set set, Set set2, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                set = positions.matchingPositions;
            }
            if ((n & 2) != 0) {
                set2 = positions.unmatchingPositions;
            }
            if ((n & 4) != 0) {
                blockPos = positions.targetedUnmatchingPosition;
            }
            return positions.copy(set, set2, blockPos);
        }

        @NotNull
        public String toString() {
            return "Positions(matchingPositions=" + this.matchingPositions + ", unmatchingPositions=" + this.unmatchingPositions + ", targetedUnmatchingPosition=" + this.targetedUnmatchingPosition + ")";
        }

        public int hashCode() {
            int result = ((Object)this.matchingPositions).hashCode();
            result = result * 31 + ((Object)this.unmatchingPositions).hashCode();
            result = result * 31 + (this.targetedUnmatchingPosition == null ? 0 : this.targetedUnmatchingPosition.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Positions)) {
                return false;
            }
            Positions positions = (Positions)other;
            if (!Intrinsics.areEqual(this.matchingPositions, positions.matchingPositions)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unmatchingPositions, positions.unmatchingPositions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetedUnmatchingPosition, (Object)positions.targetedUnmatchingPosition);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomePainterItem$Positions$Companion;", "", "<init>", "()V", "getPositions", "Ldev/aaronhowser/mods/irregular_implements/item/BiomePainterItem$Positions;", "player", "Lnet/minecraft/world/entity/player/Player;", "matchingBiome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "getTargetedPos", "Lnet/minecraft/core/BlockPos;", "positions", "", "irregular-implements-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Positions getPositions(@NotNull Player player, @NotNull Holder<Biome> matchingBiome) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter(matchingBiome, (String)"matchingBiome");
                Level level = player.level();
                BlockPos playerPos = player.blockPosition();
                Integer horizontalRadius = (Integer)ServerConfig.Companion.getCONFIG().getBiomePainterViewHorizontalRadius().get();
                Integer verticalRadius = (Integer)ServerConfig.Companion.getCONFIG().getBiomePainterViewVerticalRadius().get();
                Set matchingPositions = new LinkedHashSet();
                Set unmatchingPositions = new LinkedHashSet();
                Object[] objectArray = new BlockPos[]{playerPos};
                ArrayList toCheck = CollectionsKt.arrayListOf((Object[])objectArray);
                while (!((Collection)toCheck).isEmpty()) {
                    BlockPos pos = (BlockPos)toCheck.removeLast();
                    if (!level.isLoaded(pos)) continue;
                    Holder biomeAtPos = level.getBiome(pos);
                    if (!Intrinsics.areEqual((Object)biomeAtPos, matchingBiome)) {
                        Intrinsics.checkNotNull((Object)pos);
                        unmatchingPositions.add(pos);
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)pos);
                    matchingPositions.add(pos);
                    for (Direction direction : EntriesMappings.entries$0) {
                        int dy;
                        BlockPos offset = pos.relative(direction);
                        if (matchingPositions.contains(offset) || unmatchingPositions.contains(offset) || (dy = offset.getY() - playerPos.getY()) < -verticalRadius.intValue() || dy > verticalRadius) continue;
                        int dx = offset.getX() - playerPos.getX();
                        int dz = offset.getZ() - playerPos.getZ();
                        int hDistSqr = dx * dx + dz * dz;
                        int n = horizontalRadius;
                        Intrinsics.checkNotNull((Object)horizontalRadius);
                        if (hDistSqr > n * horizontalRadius) continue;
                        toCheck.add(offset);
                    }
                }
                BlockPos targetedIncorrectBiomePosition = this.getTargetedPos(player, unmatchingPositions);
                return new Positions(matchingPositions, unmatchingPositions, targetedIncorrectBiomePosition);
            }

            @Nullable
            public final BlockPos getTargetedPos(@NotNull Player player, @NotNull Set<? extends BlockPos> positions) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter(positions, (String)"positions");
                Vec3 eyePos = player.getEyePosition();
                Vec3 lookVec = player.getLookAngle().normalize();
                Vec3 endPos = eyePos.add(lookVec.scale(20.0));
                Pair closestHit = null;
                for (BlockPos blockPos : positions) {
                    Vec3 hitPos;
                    AABB aabb = new AABB(blockPos);
                    Optional optional = aabb.clip(eyePos, endPos);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"clip(...)");
                    if ((Vec3)OptionalsKt.getOrNull((Optional)optional) == null) continue;
                    double distSqr = eyePos.distanceToSqr(hitPos);
                    if (closestHit != null && !(distSqr < ((Number)closestHit.getFirst()).doubleValue())) continue;
                    closestHit = new Pair((Object)distSqr, (Object)blockPos);
                }
                Pair pair = closestHit;
                return pair != null ? (BlockPos)pair.getSecond() : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class EntriesMappings {
                public static final /* synthetic */ EnumEntries<Direction> entries$0;

                static {
                    entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
                }
            }
        }
    }
}

