/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.block.BlazeFireBlock;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlazeAndSteelItem;", "Lnet/minecraft/world/item/FlintAndSteelItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "tryModifyBlock", "tryPlaceFire", "Companion", "irregular-implements-1.21.1"})
public final class BlazeAndSteelItem
extends FlintAndSteelItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BlazeAndSteelItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockState originalState = context.getLevel().getBlockState(context.getClickedPos());
        BlockState modifiedState = originalState.getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
        return modifiedState != null ? this.tryModifyBlock(context) : this.tryPlaceFire(context);
    }

    private final InteractionResult tryModifyBlock(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos).getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
        if (blockState == null) {
            return InteractionResult.PASS;
        }
        BlockState newState = blockState;
        level.playSound(player, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
        level.setBlock(blockPos, newState, 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        if (player != null) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide());
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
        return interactionResult;
    }

    private final InteractionResult tryPlaceFire(UseOnContext context) {
        BlockState blockState;
        BlockPos firePos;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)(firePos = context.getClickedPos().relative(context.getClickedFace())), (Direction)context.getHorizontalDirection())) {
            return InteractionResult.FAIL;
        }
        level.playSound(player, firePos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
        BlockState potentialFireState = BaseFireBlock.getState((BlockGetter)((BlockGetter)level), (BlockPos)firePos);
        if (Intrinsics.areEqual((Object)potentialFireState.getBlock(), (Object)Blocks.SOUL_FIRE)) {
            blockState = potentialFireState;
        } else {
            Object object = ModBlocks.INSTANCE.getBLAZE_FIRE().get();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type dev.aaronhowser.mods.irregular_implements.block.BlazeFireBlock");
            blockState = ((BlazeFireBlock)object).getStateForPlacement((BlockGetter)level, firePos);
        }
        BlockState fireState = blockState;
        level.setBlock(firePos, fireState, 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, firePos);
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, firePos, itemstack);
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide());
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
        return interactionResult;
    }

    static {
        Item.Properties properties = new Item.Properties().durability(64);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"durability(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlazeAndSteelItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

