/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/ChunkAnalyzerItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nChunkAnalyzerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkAnalyzerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/ChunkAnalyzerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1068#2:72\n*S KotlinDebug\n*F\n+ 1 ChunkAnalyzerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/ChunkAnalyzerItem\n*L\n52#1:72\n*E\n"})
public final class ChunkAnalyzerItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public ChunkAnalyzerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }
        LevelChunk chunk = level.getChunkAt(player.blockPosition());
        IdentityHashMap<Object, MutableInt> blockStateCounts = new IdentityHashMap<Object, MutableInt>();
        int minX = chunk.getPos().getMinBlockX();
        int maxX = chunk.getPos().getMaxBlockX();
        int minZ = chunk.getPos().getMinBlockZ();
        int maxZ = chunk.getPos().getMaxBlockZ();
        int minY = chunk.getMinBuildHeight();
        int maxY = chunk.getMaxBuildHeight();
        int x = minX;
        if (x <= maxX) {
            while (true) {
                int z;
                if ((z = minZ) <= maxZ) {
                    while (true) {
                        int y;
                        if ((y = minY) <= maxY) {
                            while (true) {
                                BlockState blockState;
                                if (!(blockState = chunk.getBlockState(new BlockPos(x, y, z))).isAir()) {
                                    blockStateCounts.computeIfAbsent(blockState.getBlock(), arg_0 -> ChunkAnalyzerItem.use$lambda$1(ChunkAnalyzerItem::use$lambda$0, arg_0)).increment();
                                }
                                if (y == maxY) break;
                                ++y;
                            }
                        }
                        if (z == maxZ) break;
                        ++z;
                    }
                }
                if (x == maxX) break;
                ++x;
            }
        }
        Set set = blockStateCounts.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedByDescending$iv = set;
        boolean $i$f$sortedByDescending = false;
        for (Object e : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((MutableInt)it.getValue());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((MutableInt)it.getValue())));
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Map.Entry entry2 = (Map.Entry)e;
            Block block = (Block)entry2.getKey();
            MutableInt count = (MutableInt)entry2.getValue();
            player.sendSystemMessage((Component)Component.literal((String)(block.getName().getString() + " x" + count.getValue())));
        }
        player.getCooldowns().addCooldown((Item)this, 20);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)usedStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    private static final MutableInt use$lambda$0(Block it) {
        return new MutableInt(0);
    }

    private static final MutableInt use$lambda$1(Function1 $tmp0, Object p0) {
        return (MutableInt)$tmp0.invoke(p0);
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/ChunkAnalyzerItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

