/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/LotusBlossomItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getUseDuration", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "finishUsingItem", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Companion", "irregular-implements-1.21.1"})
public final class LotusBlossomItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final FoodProperties FOOD_PROPERTIES = new FoodProperties.Builder().alwaysEdible().build();
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public LotusBlossomItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 10;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.EAT;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        int amountToEat;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        int n = amountToEat = livingEntity.isShiftKeyDown() ? stack.getCount() : 1;
        if (livingEntity instanceof Player) {
            int amountXp = 0;
            for (int i = 0; i < amountToEat; ++i) {
                amountXp += 3 + level.random.nextInt(5) + level.random.nextInt(5);
            }
            ((Player)livingEntity).giveExperiencePoints(amountXp);
        }
        ItemStack remainder = stack.copy();
        remainder.consume(amountToEat, livingEntity);
        Intrinsics.checkNotNull((Object)remainder);
        return remainder;
    }

    static {
        Item.Properties properties = new Item.Properties().food(FOOD_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"food(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/LotusBlossomItem$Companion;", "", "<init>", "()V", "FOOD_PROPERTIES", "Lnet/minecraft/world/food/FoodProperties;", "kotlin.jvm.PlatformType", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

