/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.menu.item_filter;

import dev.aaronhowser.mods.aaron.menu.MenuWithButtons;
import dev.aaronhowser.mods.irregular_implements.item.component.ItemFilterDataComponent;
import dev.aaronhowser.mods.irregular_implements.menu.HeldItemContainerMenu;
import dev.aaronhowser.mods.irregular_implements.menu.item_filter.ItemFilterSlot;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.registry.ModMenuTypes;
import dev.aaronhowser.mods.irregular_implements.util.FilterEntry;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J&\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020$H\u0002\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterMenu;", "Ldev/aaronhowser/mods/irregular_implements/menu/HeldItemContainerMenu;", "Ldev/aaronhowser/mods/aaron/menu/MenuWithButtons;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;)V", "getFilterComponent", "Ldev/aaronhowser/mods/irregular_implements/item/component/ItemFilterDataComponent;", "getFilter", "Lnet/minecraft/core/NonNullList;", "Ldev/aaronhowser/mods/irregular_implements/util/FilterEntry;", "getIsBlacklist", "", "setIsBlacklist", "", "value", "addSlots", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "stillValid", "handleButtonPressed", "buttonId", "pressLeftButton", "slotIndex", "pressRightButton", "toggleNeedsComponents", "filter", "entry", "Ldev/aaronhowser/mods/irregular_implements/util/FilterEntry$Item;", "cycleTag", "Ldev/aaronhowser/mods/irregular_implements/util/FilterEntry$Tag;", "Companion", "irregular-implements-1.21.1"})
public final class ItemFilterMenu
extends HeldItemContainerMenu
implements MenuWithButtons {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int TOGGLE_BLACKLIST_BUTTON_ID = 0;

    public ItemFilterMenu(int containerId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        super(ModItems.INSTANCE.getITEM_FILTER(), (MenuType)ModMenuTypes.INSTANCE.getITEM_FILTER().get(), containerId, playerInventory);
        this.addSlots();
        this.addPlayerInventorySlots(59);
    }

    private final ItemFilterDataComponent getFilterComponent() {
        return (ItemFilterDataComponent)this.getHeldItemStack().get((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER());
    }

    @Nullable
    public final NonNullList<FilterEntry> getFilter() {
        ItemFilterDataComponent itemFilterDataComponent = this.getFilterComponent();
        return itemFilterDataComponent != null ? itemFilterDataComponent.getEntries() : null;
    }

    public final boolean getIsBlacklist() {
        ItemFilterDataComponent itemFilterDataComponent = this.getFilterComponent();
        return itemFilterDataComponent != null ? itemFilterDataComponent.isBlacklist() : false;
    }

    private final void setIsBlacklist(boolean value) {
        ItemFilterDataComponent itemFilterDataComponent = this.getFilterComponent();
        if (itemFilterDataComponent == null) {
            return;
        }
        ItemFilterDataComponent filterComponent = itemFilterDataComponent;
        if (value == filterComponent.isBlacklist()) {
            return;
        }
        this.getHeldItemStack().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)ItemFilterDataComponent.copy$default(filterComponent, null, value, 1, null));
    }

    public void addSlots() {
        RegistryAccess holderLookup = this.getPlayerInventory().player.registryAccess();
        for (int index = 0; index < 9; ++index) {
            int x = 8 + index * 18;
            int y = 26;
            Supplier<ItemStack> supplier = this::getHeldItemStack;
            Intrinsics.checkNotNull((Object)holderLookup);
            ItemFilterSlot slot = new ItemFilterSlot(supplier, (HolderLookup.Provider)holderLookup, x, y);
            this.addSlot((Slot)slot);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getItemInHand(this.getHand()).is((Holder)ModItems.INSTANCE.getITEM_FILTER());
    }

    public void handleButtonPressed(int buttonId) {
        int n = buttonId;
        if (n == 0) {
            this.setIsBlacklist(!this.getIsBlacklist());
        } else {
            boolean bl = 1 <= n ? n < 10 : false;
            if (bl) {
                this.pressLeftButton(buttonId - 1);
            } else {
                boolean bl2 = 10 <= n ? n < 19 : false;
                if (bl2) {
                    this.pressRightButton(buttonId - 10);
                }
            }
        }
    }

    private final void pressLeftButton(int slotIndex) {
        FilterEntry filterEntry;
        NonNullList<FilterEntry> nonNullList = this.getFilter();
        if (nonNullList == null) {
            return;
        }
        NonNullList<FilterEntry> filter = nonNullList;
        FilterEntry filterEntry2 = (FilterEntry)CollectionsKt.getOrNull((List)((List)filter), (int)slotIndex);
        if (filterEntry2 == null) {
            return;
        }
        FilterEntry entry2 = filterEntry2;
        FilterEntry filterEntry3 = entry2;
        if (filterEntry3 instanceof FilterEntry.Tag) {
            filterEntry = ((FilterEntry.Tag)entry2).getAsSpecificItemEntry();
        } else if (filterEntry3 instanceof FilterEntry.Item) {
            List list = ((FilterEntry.Item)entry2).getStack().getTags().toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            TagKey tagKey = (TagKey)CollectionsKt.firstOrNull(list);
            if (tagKey == null) {
                return;
            }
            TagKey tag = tagKey;
            ItemStack itemStack = ((FilterEntry.Item)entry2).getStack().copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            filterEntry = new FilterEntry.Tag((TagKey<Item>)tag, itemStack);
        } else {
            return;
        }
        FilterEntry newEntry = filterEntry;
        List newFilter = CollectionsKt.toMutableList((Collection)((Collection)filter));
        newFilter.set(slotIndex, newEntry);
        this.getHeldItemStack().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)new ItemFilterDataComponent(newFilter, this.getIsBlacklist()));
    }

    private final void pressRightButton(int slotIndex) {
        NonNullList<FilterEntry> nonNullList = this.getFilter();
        if (nonNullList == null) {
            return;
        }
        NonNullList<FilterEntry> filter = nonNullList;
        FilterEntry filterEntry = (FilterEntry)CollectionsKt.getOrNull((List)((List)filter), (int)slotIndex);
        if (filterEntry == null) {
            return;
        }
        FilterEntry entry2 = filterEntry;
        if (entry2 instanceof FilterEntry.Item) {
            this.toggleNeedsComponents(slotIndex, filter, (FilterEntry.Item)entry2);
        } else if (entry2 instanceof FilterEntry.Tag) {
            this.cycleTag(slotIndex, filter, (FilterEntry.Tag)entry2);
        }
    }

    private final void toggleNeedsComponents(int slotIndex, NonNullList<FilterEntry> filter, FilterEntry.Item entry2) {
        FilterEntry.Item newEntry = FilterEntry.Item.copy$default(entry2, null, !entry2.getRequireSameComponents(), 1, null);
        List newFilter = CollectionsKt.toMutableList((Collection)((Collection)filter));
        newFilter.set(slotIndex, newEntry);
        this.getHeldItemStack().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)new ItemFilterDataComponent(newFilter, this.getIsBlacklist()));
    }

    private final void cycleTag(int slotIndex, NonNullList<FilterEntry> filter, FilterEntry.Tag entry2) {
        TagKey<Item> nextTag = entry2.getNextTag();
        FilterEntry.Tag newEntry = FilterEntry.Tag.copy$default(entry2, nextTag, null, 2, null);
        List newFilter = CollectionsKt.toMutableList((Collection)((Collection)filter));
        newFilter.set(slotIndex, newEntry);
        this.getHeldItemStack().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)new ItemFilterDataComponent(newFilter, this.getIsBlacklist()));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterMenu$Companion;", "", "<init>", "()V", "getLeftButtonId", "", "slotIndex", "getRightButtonId", "TOGGLE_BLACKLIST_BUTTON_ID", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLeftButtonId(int slotIndex) {
            return slotIndex + 1;
        }

        public final int getRightButtonId(int slotIndex) {
            return slotIndex + 10;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

