/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.recipe.crafting;

import dev.aaronhowser.mods.irregular_implements.recipe.crafting.LubricateBootRecipe;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/WashBootRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "craftingCategory", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "bootIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "getBootIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "waterIngredient", "getWaterIngredient", "matches", "", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nWashBootRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WashBootRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/WashBootRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,80:1\n1563#2:81\n1634#2,3:82\n37#3,2:85\n*S KotlinDebug\n*F\n+ 1 WashBootRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/WashBootRecipe\n*L\n22#1:81\n22#1:82,3\n22#1:85,2\n*E\n"})
public final class WashBootRecipe
extends CustomRecipe {
    @NotNull
    private final Ingredient bootIngredient;
    @NotNull
    private final Ingredient waterIngredient;

    /*
     * WARNING - void declaration
     */
    public WashBootRecipe(@NotNull CraftingBookCategory craftingCategory) {
        Collection<Item> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)craftingCategory, (String)"craftingCategory");
        super(craftingCategory);
        Iterable iterable = LubricateBootRecipe.Companion.getALL_BOOTS();
        DataComponentMap dataComponentMap = DataComponentMap.builder().set((Supplier)ModDataComponents.LUBRICATED, (Object)Unit.INSTANCE).build();
        boolean bl = false;
        WashBootRecipe washBootRecipe = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemStack itemStack = (ItemStack)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getItem());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Item[] itemArray = thisCollection$iv.toArray(new Item[0]);
        Ingredient ingredient = DataComponentIngredient.of((boolean)bl, (DataComponentMap)dataComponentMap, (ItemLike[])((ItemLike[])Arrays.copyOf(itemArray, itemArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        washBootRecipe.bootIngredient = ingredient;
        Holder holder = Potions.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"WATER");
        Ingredient ingredient2 = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)holder));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"of(...)");
        this.waterIngredient = ingredient2;
    }

    public /* synthetic */ WashBootRecipe(CraftingBookCategory craftingBookCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            craftingBookCategory = CraftingBookCategory.MISC;
        }
        this(craftingBookCategory);
    }

    @NotNull
    public final Ingredient getBootIngredient() {
        return this.bootIngredient;
    }

    @NotNull
    public final Ingredient getWaterIngredient() {
        return this.waterIngredient;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack bootStack = null;
        ItemStack waterStack = null;
        for (ItemStack stack : input.items()) {
            if (this.bootIngredient.test(stack)) {
                if (bootStack != null) {
                    return false;
                }
                bootStack = stack;
            }
            if (this.waterIngredient.test(stack)) {
                if (waterStack != null) {
                    return false;
                }
                waterStack = stack;
            }
            if (bootStack == null || waterStack == null) continue;
        }
        return bootStack != null && waterStack != null && bootStack.has((Supplier)ModDataComponents.LUBRICATED);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack bootStack = null;
        ItemStack waterStack = null;
        for (ItemStack stack : input.items()) {
            if (this.bootIngredient.test(stack)) {
                if (bootStack != null) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
                bootStack = stack;
            }
            if (this.waterIngredient.test(stack)) {
                if (waterStack != null) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
                waterStack = stack;
            }
            if (bootStack == null || waterStack == null) continue;
        }
        if (bootStack == null || waterStack == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack newBootStack = bootStack.copy();
        newBootStack.remove((Supplier)ModDataComponents.LUBRICATED);
        Intrinsics.checkNotNull((Object)newBootStack);
        return newBootStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getWASH_BOOT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    public WashBootRecipe() {
        this(null, 1, null);
    }
}

