/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.world.feature;

import dev.aaronhowser.mods.irregular_implements.IrregularImplements;
import dev.aaronhowser.mods.irregular_implements.block.SpecialChestBlock;
import dev.aaronhowser.mods.irregular_implements.datagen.loot.ModChestLootSubprovider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBiomeTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.util.StructureSchematics;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/world/feature/NatureCoreFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/NoneFeatureConfiguration;", "<init>", "()V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "Companion", "irregular-implements-1.21.1"})
public final class NatureCoreFeature
extends Feature<NoneFeatureConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NatureCoreFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        if (!level.getFluidState(origin.below()).isEmpty()) {
            return false;
        }
        RandomSource random = context.random();
        Holder biome = level.getBiome(origin);
        Intrinsics.checkNotNull((Object)biome);
        BlockState log = Companion.getLogFromBiome((Holder<Biome>)biome);
        BlockState leaves = Companion.getLeavesFromBiome((Holder<Biome>)biome);
        Map<BlockPos, BlockState> core = StructureSchematics.INSTANCE.getNatureCore(log, leaves);
        for (Map.Entry<BlockPos, BlockState> entry2 : core.entrySet()) {
            BlockPos offset = entry2.getKey();
            BlockState state = entry2.getValue();
            BlockPos pos = origin.offset((Vec3i)offset);
            level.setBlock(pos, state, 3);
        }
        BlockPos positionAbove = origin.above(4);
        int chestPlaceRadius = 7;
        int chestTries = 0;
        BlockPos chestPos = positionAbove;
        block1: while (chestTries < chestPlaceRadius * chestPlaceRadius) {
            int dX = random.nextInt(chestPlaceRadius * 2) - chestPlaceRadius;
            int dZ = random.nextInt(chestPlaceRadius * 2) - chestPlaceRadius;
            chestPos = positionAbove.offset(dX, 0, dZ);
            while (!level.isOutsideBuildHeight(chestPos) && level.isEmptyBlock(chestPos)) {
                if (level.getFluidState(chestPos = chestPos.below()).isEmpty()) continue;
                continue block1;
            }
            if (!level.isEmptyBlock(chestPos = chestPos.above())) {
                ++chestTries;
                continue;
            }
            BlockPos vectorFromOrigin = chestPos.subtract((Vec3i)origin);
            Direction directionFromOrigin = Direction.fromDelta((int)vectorFromOrigin.getX(), (int)0, (int)vectorFromOrigin.getZ());
            BlockState blockState = ((SpecialChestBlock)((Object)ModBlocks.INSTANCE.getNATURE_CHEST().get())).defaultBlockState();
            Property property = (Property)ChestBlock.FACING;
            Direction direction = directionFromOrigin;
            if (direction == null) {
                direction = Direction.NORTH;
            }
            BlockState chestState = (BlockState)blockState.setValue(property, (Comparable)direction);
            level.setBlock(chestPos, chestState, 3);
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)((BlockGetter)level), (RandomSource)random, (BlockPos)chestPos, ModChestLootSubprovider.Companion.getNATURE_CORE());
            break;
        }
        IrregularImplements.LOGGER.debug("Placed Nature Core at " + origin + ", with its chest at " + chestPos);
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/world/feature/NatureCoreFeature$Companion;", "", "<init>", "()V", "getLogFromBiome", "Lnet/minecraft/world/level/block/state/BlockState;", "biome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "getLeavesFromBiome", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockState getLogFromBiome(@NotNull Holder<Biome> biome) {
            Intrinsics.checkNotNullParameter(biome, (String)"biome");
            Object object = (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_BIRCH()) ? Blocks.BIRCH_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_DARK_OAK()) ? Blocks.DARK_OAK_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_JUNGLE()) ? Blocks.JUNGLE_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_SPRUCE()) ? Blocks.SPRUCE_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_ACACIA()) ? Blocks.ACACIA_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_MANGROVE()) ? Blocks.MANGROVE_LOG : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_OAK()) ? Blocks.OAK_LOG : Blocks.OAK_LOG))))))).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }

        @NotNull
        public final BlockState getLeavesFromBiome(@NotNull Holder<Biome> biome) {
            Intrinsics.checkNotNullParameter(biome, (String)"biome");
            Object object = (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_BIRCH()) ? Blocks.BIRCH_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_DARK_OAK()) ? Blocks.DARK_OAK_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_JUNGLE()) ? Blocks.JUNGLE_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_SPRUCE()) ? Blocks.SPRUCE_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_ACACIA()) ? Blocks.ACACIA_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_MANGROVE()) ? Blocks.MANGROVE_LEAVES : (biome.is(ModBiomeTagsProvider.Companion.getNATURE_CORE_OAK()) ? Blocks.OAK_LEAVES : Blocks.OAK_LEAVES))))))).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

