/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jags;

import org.jetbrains.annotations.NotNull;

public interface SimpleColor {
    public static final SimpleColor WHITE = SimpleColor.fromRGB(255, 255, 255);
    public static final SimpleColor BLACK = SimpleColor.fromRGB(0, 0, 0);
    public static final SimpleColor RED = SimpleColor.fromRGB(255, 0, 0);
    public static final SimpleColor GREEN = SimpleColor.fromRGB(0, 255, 0);
    public static final SimpleColor BLUE = SimpleColor.fromRGB(0, 0, 255);
    public static final SimpleColor YELLOW = SimpleColor.fromRGB(255, 255, 0);
    public static final SimpleColor PURPLE = SimpleColor.fromRGB(255, 0, 255);
    public static final SimpleColor CYAN = SimpleColor.fromRGB(0, 255, 255);
    public static final SimpleColor ORANGE = SimpleColor.fromRGB(255, 165, 0);
    public static final SimpleColor PINK = SimpleColor.fromRGB(255, 192, 203);
    public static final SimpleColor GRAY = SimpleColor.fromRGB(128, 128, 128);
    public static final SimpleColor LIGHT_GRAY = SimpleColor.fromRGB(192, 192, 192);
    public static final SimpleColor DARK_GRAY = SimpleColor.fromRGB(64, 64, 64);
    public static final SimpleColor BROWN = SimpleColor.fromRGB(165, 42, 42);

    @NotNull
    public static SimpleColor fromRGB(int red, int green, int blue) {
        return new RGB(red, green, blue);
    }

    @NotNull
    public static SimpleColor fromHex(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("Hex cannot be null");
        }
        if (!hex.startsWith("#")) {
            throw new IllegalArgumentException("Hex must start with #");
        }
        hex = hex.substring(1);
        try {
            return SimpleColor.fromRGB(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex string", e);
        }
    }

    public int red();

    public int green();

    public int blue();

    default public String hex() {
        return String.format("#%02x%02x%02x", this.red(), this.green(), this.blue());
    }

    default public int asRGB() {
        return this.red() << 16 | this.green() << 8 | this.blue();
    }

    public record RGB(int red, int green, int blue) implements SimpleColor
    {
    }
}

