/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.fluids.refinedt3fuel;

import com.direwolf20.justdirethings.common.fluids.basefluids.RefinedFuel;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class RefinedT3Fuel
extends BaseFlowingFluid
implements RefinedFuel {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(Registration.REFINED_T3_FLUID_TYPE, Registration.REFINED_T3_FLUID_FLOWING, Registration.REFINED_T3_FLUID_SOURCE).bucket(Registration.REFINED_T3_FLUID_BUCKET).block(Registration.REFINED_T3_FLUID_BLOCK);

    protected RefinedT3Fuel(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    @Override
    public int fePerMb() {
        return (Integer)Config.FUEL_TIER3_FE_PER_MB.get();
    }

    public Fluid getFlowing() {
        return (Fluid)Registration.REFINED_T3_FLUID_FLOWING.get();
    }

    public Fluid getSource() {
        return (Fluid)Registration.REFINED_T3_FLUID_SOURCE.get();
    }

    public Item getBucket() {
        return (Item)Registration.REFINED_T3_FLUID_BUCKET.get();
    }

    protected boolean canConvertToSource(Level pLevel) {
        return false;
    }

    public static class Source
    extends RefinedT3Fuel {
        public Source() {
            super(PROPERTIES);
        }

        public int getAmount(FluidState pState) {
            return 8;
        }

        public boolean isSource(FluidState pState) {
            return true;
        }
    }

    public static class Flowing
    extends RefinedT3Fuel {
        public Flowing() {
            super(PROPERTIES);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.createFluidStateDefinition(pBuilder);
            pBuilder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState pState) {
            return false;
        }
    }
}

