/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.recipetypes.builders;

import com.devdyna.justdynathings.recipetypes.type.ParadoxMixerRecipe;
import com.devdyna.justdynathings.utils.DataGenUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class ParadoxMixerRecipeBuilder
implements RecipeBuilder {
    private FluidStack input;
    private Ingredient catalyst;
    private FluidStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public static ParadoxMixerRecipeBuilder of() {
        return new ParadoxMixerRecipeBuilder();
    }

    public ParadoxMixerRecipeBuilder input(FluidStack i) {
        this.input = i;
        return this;
    }

    public ParadoxMixerRecipeBuilder catalyst(Ingredient i) {
        this.catalyst = i;
        return this;
    }

    public ParadoxMixerRecipeBuilder output(FluidStack i) {
        this.output = i;
        return this;
    }

    public ParadoxMixerRecipeBuilder unlockedBy() {
        return this.unlockedBy("justdynathings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.catalyst.getItems()[0].getItem()}));
    }

    public ParadoxMixerRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ParadoxMixerRecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return null;
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, DataGenUtil.getResource("fluidtank/" + DataGenUtil.getPath(this.output.getFluid()) + "_from_" + DataGenUtil.getPath(this.input.getFluid()) + "_with_" + DataGenUtil.getPath(this.catalyst.getItems()[0].getItem()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ParadoxMixerRecipe shapelessrecipe = new ParadoxMixerRecipe(this.input, this.catalyst, this.output);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

