/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;

public class VanillaStatsRegistry {
    public static final Map<ResourceLocation, Leaderboard> VANILLA_STATS = new LinkedHashMap<ResourceLocation, Leaderboard>();

    public static void register() {
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_blocks_mined"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_blocks_mined"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_blocks_mined"), player -> {
            int total = 0;
            for (Stat stat : Stats.BLOCK_MINED) {
                total += player.getStats().getValue(stat);
            }
            return Component.literal((String)String.valueOf(total));
        }, Comparator.comparingInt(player -> {
            int total = 0;
            for (Stat stat : Stats.BLOCK_MINED) {
                total += player.getStats().getValue(stat);
            }
            return total;
        }).reversed(), player -> {
            for (Stat stat : Stats.BLOCK_MINED) {
                if (player.getStats().getValue(stat) <= 0) continue;
                return true;
            }
            return false;
        }));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_crafted"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_crafted"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_items_crafted"), player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_CRAFTED) {
                total += player.getStats().getValue(stat);
            }
            return Component.literal((String)String.valueOf(total));
        }, Comparator.comparingInt(player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_CRAFTED) {
                total += player.getStats().getValue(stat);
            }
            return total;
        }).reversed(), player -> {
            for (Stat stat : Stats.ITEM_CRAFTED) {
                if (player.getStats().getValue(stat) <= 0) continue;
                return true;
            }
            return false;
        }));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_used"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_used"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_items_used"), player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_USED) {
                total += player.getStats().getValue(stat);
            }
            return Component.literal((String)String.valueOf(total));
        }, Comparator.comparingInt(player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_USED) {
                total += player.getStats().getValue(stat);
            }
            return total;
        }).reversed(), player -> {
            for (Stat stat : Stats.ITEM_USED) {
                if (player.getStats().getValue(stat) <= 0) continue;
                return true;
            }
            return false;
        }));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_broken"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_broken"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_items_broken"), player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_BROKEN) {
                total += player.getStats().getValue(stat);
            }
            return Component.literal((String)String.valueOf(total));
        }, Comparator.comparingInt(player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_BROKEN) {
                total += player.getStats().getValue(stat);
            }
            return total;
        }).reversed(), player -> {
            for (Stat stat : Stats.ITEM_BROKEN) {
                if (player.getStats().getValue(stat) <= 0) continue;
                return true;
            }
            return false;
        }));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_picked_up"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_items_picked_up"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_items_picked_up"), player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_PICKED_UP) {
                total += player.getStats().getValue(stat);
            }
            return Component.literal((String)String.valueOf(total));
        }, Comparator.comparingInt(player -> {
            int total = 0;
            for (Stat stat : Stats.ITEM_PICKED_UP) {
                total += player.getStats().getValue(stat);
            }
            return total;
        }).reversed(), player -> {
            for (Stat stat : Stats.ITEM_PICKED_UP) {
                if (player.getStats().getValue(stat) <= 0) continue;
                return true;
            }
            return false;
        }));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_dealt"), Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_taken"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_taken"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_taken"), Stats.CUSTOM.get((Object)Stats.DAMAGE_TAKEN), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_blocked_by_shield"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_blocked_by_shield"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_blocked_by_shield"), Stats.CUSTOM.get((Object)Stats.DAMAGE_BLOCKED_BY_SHIELD), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_absorbed"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_absorbed"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_absorbed"), Stats.CUSTOM.get((Object)Stats.DAMAGE_ABSORBED), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_resisted"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_resisted"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_resisted"), Stats.CUSTOM.get((Object)Stats.DAMAGE_RESISTED), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt_absorbed"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt_absorbed"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_dealt_absorbed"), Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT_ABSORBED), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt_resisted"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"damage_dealt_resisted"), (Component)Component.translatable((String)"leaderboard.leaderboards.damage_dealt_resisted"), Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT_RESISTED), false, Leaderboard.FromStat.DAMAGE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"animals_bred"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"animals_bred"), (Component)Component.translatable((String)"leaderboard.leaderboards.animals_bred"), Stats.CUSTOM.get((Object)Stats.ANIMALS_BRED), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fish_caught"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fish_caught"), (Component)Component.translatable((String)"leaderboard.leaderboards.fish_caught"), Stats.CUSTOM.get((Object)Stats.FISH_CAUGHT), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fly_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fly_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.fly_distance"), Stats.CUSTOM.get((Object)Stats.FLY_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"swim_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"swim_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.swim_distance"), Stats.CUSTOM.get((Object)Stats.SWIM_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"horse_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"horse_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.horse_distance"), Stats.CUSTOM.get((Object)Stats.HORSE_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"boat_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"boat_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.boat_distance"), Stats.CUSTOM.get((Object)Stats.BOAT_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"elytra_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"elytra_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.elytra_distance"), Stats.CUSTOM.get((Object)Stats.AVIATE_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"minecart_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"minecart_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.minecart_distance"), Stats.CUSTOM.get((Object)Stats.MINECART_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"pig_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"pig_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.pig_distance"), Stats.CUSTOM.get((Object)Stats.PIG_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"strider_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"strider_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.strider_distance"), Stats.CUSTOM.get((Object)Stats.STRIDER_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"walk_under_water_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"walk_under_water_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.walk_under_water_distance"), Stats.CUSTOM.get((Object)Stats.WALK_UNDER_WATER_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"walk_on_water_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"walk_on_water_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.walk_on_water_distance"), Stats.CUSTOM.get((Object)Stats.WALK_ON_WATER_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"climb_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"climb_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.climb_distance"), Stats.CUSTOM.get((Object)Stats.CLIMB_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fall_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"fall_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.fall_distance"), Stats.CUSTOM.get((Object)Stats.FALL_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crouch_distance"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crouch_distance"), (Component)Component.translatable((String)"leaderboard.leaderboards.crouch_distance"), Stats.CUSTOM.get((Object)Stats.CROUCH_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crouch_time"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crouch_time"), (Component)Component.translatable((String)"leaderboard.leaderboards.crouch_time"), Stats.CUSTOM.get((Object)Stats.CROUCH_TIME), false, Leaderboard.FromStat.TIME));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_since_death"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_since_death"), (Component)Component.translatable((String)"leaderboard.leaderboards.time_since_death"), Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH), false, Leaderboard.FromStat.TIME));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_since_rest"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_since_rest"), (Component)Component.translatable((String)"leaderboard.leaderboards.time_since_rest"), Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), false, Leaderboard.FromStat.TIME));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"villager_trades"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"villager_trades"), (Component)Component.translatable((String)"leaderboard.leaderboards.villager_trades"), Stats.CUSTOM.get((Object)Stats.TRADED_WITH_VILLAGER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"talked_to_villager"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"talked_to_villager"), (Component)Component.translatable((String)"leaderboard.leaderboards.talked_to_villager"), Stats.CUSTOM.get((Object)Stats.TALKED_TO_VILLAGER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"raids_won"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"raids_won"), (Component)Component.translatable((String)"leaderboard.leaderboards.raids_won"), Stats.CUSTOM.get((Object)Stats.RAID_WIN), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"raids_triggered"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"raids_triggered"), (Component)Component.translatable((String)"leaderboard.leaderboards.raids_triggered"), Stats.CUSTOM.get((Object)Stats.RAID_TRIGGER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"target_hit"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"target_hit"), (Component)Component.translatable((String)"leaderboard.leaderboards.target_hit"), Stats.CUSTOM.get((Object)Stats.TARGET_HIT), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"bells_rung"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"bells_rung"), (Component)Component.translatable((String)"leaderboard.leaderboards.bells_rung"), Stats.CUSTOM.get((Object)Stats.BELL_RING), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"items_dropped"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"items_dropped"), (Component)Component.translatable((String)"leaderboard.leaderboards.items_dropped"), Stats.CUSTOM.get((Object)Stats.DROP), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"enchantments_done"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"enchantments_done"), (Component)Component.translatable((String)"leaderboard.leaderboards.enchantments_done"), Stats.CUSTOM.get((Object)Stats.ENCHANT_ITEM), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"times_slept"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"times_slept"), (Component)Component.translatable((String)"leaderboard.leaderboards.times_slept"), Stats.CUSTOM.get((Object)Stats.SLEEP_IN_BED), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_world_time"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"total_world_time"), (Component)Component.translatable((String)"leaderboard.leaderboards.total_world_time"), Stats.CUSTOM.get((Object)Stats.TOTAL_WORLD_TIME), false, Leaderboard.FromStat.TIME));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cake_slices_eaten"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cake_slices_eaten"), (Component)Component.translatable((String)"leaderboard.leaderboards.cake_slices_eaten"), Stats.CUSTOM.get((Object)Stats.EAT_CAKE_SLICE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"chests_opened"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"chests_opened"), (Component)Component.translatable((String)"leaderboard.leaderboards.chests_opened"), Stats.CUSTOM.get((Object)Stats.OPEN_CHEST), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"ender_chests_opened"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"ender_chests_opened"), (Component)Component.translatable((String)"leaderboard.leaderboards.ender_chests_opened"), Stats.CUSTOM.get((Object)Stats.OPEN_ENDERCHEST), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"shulker_boxes_opened"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"shulker_boxes_opened"), (Component)Component.translatable((String)"leaderboard.leaderboards.shulker_boxes_opened"), Stats.CUSTOM.get((Object)Stats.OPEN_SHULKER_BOX), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"barrels_opened"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"barrels_opened"), (Component)Component.translatable((String)"leaderboard.leaderboards.barrels_opened"), Stats.CUSTOM.get((Object)Stats.OPEN_BARREL), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"furnace_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"furnace_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.furnace_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_FURNACE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crafting_table_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"crafting_table_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.crafting_table_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_CRAFTING_TABLE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"blast_furnace_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"blast_furnace_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.blast_furnace_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_BLAST_FURNACE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"smoker_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"smoker_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.smoker_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_SMOKER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"anvil_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"anvil_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.anvil_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_ANVIL), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"grindstone_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"grindstone_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.grindstone_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_GRINDSTONE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"smithing_table_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"smithing_table_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.smithing_table_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_SMITHING_TABLE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"beacon_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"beacon_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.beacon_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_BEACON), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"brewing_stand_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"brewing_stand_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.brewing_stand_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_BREWINGSTAND), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"lectern_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"lectern_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.lectern_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_LECTERN), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"campfire_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"campfire_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.campfire_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_CAMPFIRE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cartography_table_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cartography_table_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.cartography_table_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_CARTOGRAPHY_TABLE), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"loom_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"loom_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.loom_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_LOOM), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"stonecutter_interactions"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"stonecutter_interactions"), (Component)Component.translatable((String)"leaderboard.leaderboards.stonecutter_interactions"), Stats.CUSTOM.get((Object)Stats.INTERACT_WITH_STONECUTTER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"hopper_inspections"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"hopper_inspections"), (Component)Component.translatable((String)"leaderboard.leaderboards.hopper_inspections"), Stats.CUSTOM.get((Object)Stats.INSPECT_HOPPER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"dropper_inspections"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"dropper_inspections"), (Component)Component.translatable((String)"leaderboard.leaderboards.dropper_inspections"), Stats.CUSTOM.get((Object)Stats.INSPECT_DROPPER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"dispenser_inspections"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"dispenser_inspections"), (Component)Component.translatable((String)"leaderboard.leaderboards.dispenser_inspections"), Stats.CUSTOM.get((Object)Stats.INSPECT_DISPENSER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"noteblocks_played"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"noteblocks_played"), (Component)Component.translatable((String)"leaderboard.leaderboards.noteblocks_played"), Stats.CUSTOM.get((Object)Stats.PLAY_NOTEBLOCK), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"noteblocks_tuned"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"noteblocks_tuned"), (Component)Component.translatable((String)"leaderboard.leaderboards.noteblocks_tuned"), Stats.CUSTOM.get((Object)Stats.TUNE_NOTEBLOCK), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"flowers_potted"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"flowers_potted"), (Component)Component.translatable((String)"leaderboard.leaderboards.flowers_potted"), Stats.CUSTOM.get((Object)Stats.POT_FLOWER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"trapped_chests_triggered"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"trapped_chests_triggered"), (Component)Component.translatable((String)"leaderboard.leaderboards.trapped_chests_triggered"), Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"records_played"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"records_played"), (Component)Component.translatable((String)"leaderboard.leaderboards.records_played"), Stats.CUSTOM.get((Object)Stats.PLAY_RECORD), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cauldrons_filled"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cauldrons_filled"), (Component)Component.translatable((String)"leaderboard.leaderboards.cauldrons_filled"), Stats.CUSTOM.get((Object)Stats.FILL_CAULDRON), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cauldrons_used"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"cauldrons_used"), (Component)Component.translatable((String)"leaderboard.leaderboards.cauldrons_used"), Stats.CUSTOM.get((Object)Stats.USE_CAULDRON), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"armor_pieces_cleaned"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"armor_pieces_cleaned"), (Component)Component.translatable((String)"leaderboard.leaderboards.armor_pieces_cleaned"), Stats.CUSTOM.get((Object)Stats.CLEAN_ARMOR), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"banners_cleaned"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"banners_cleaned"), (Component)Component.translatable((String)"leaderboard.leaderboards.banners_cleaned"), Stats.CUSTOM.get((Object)Stats.CLEAN_BANNER), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"shulker_boxes_cleaned"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"shulker_boxes_cleaned"), (Component)Component.translatable((String)"leaderboard.leaderboards.shulker_boxes_cleaned"), Stats.CUSTOM.get((Object)Stats.CLEAN_SHULKER_BOX), false));
        VANILLA_STATS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"leave_game"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"leave_game"), (Component)Component.translatable((String)"leaderboard.leaderboards.leave_game"), Stats.CUSTOM.get((Object)Stats.LEAVE_GAME), false));
    }
}

