/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.LeaderboardValue;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.gui.LeaderboardScreen;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LeaderboardResponsePacket(Component title, List<LeaderboardValue> values) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LeaderboardResponsePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"leaderboard_response"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LeaderboardResponsePacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LeaderboardResponsePacket>(){

        public LeaderboardResponsePacket decode(RegistryFriendlyByteBuf buf) {
            Component title = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            int size = buf.readVarInt();
            ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
            for (int i = 0; i < size; ++i) {
                LeaderboardValue value = new LeaderboardValue();
                value.username = buf.readUtf();
                value.value = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
                value.color = ChatFormatting.getById((int)buf.readByte());
                values.add(value);
            }
            return new LeaderboardResponsePacket(title, values);
        }

        public void encode(RegistryFriendlyByteBuf buf, LeaderboardResponsePacket packet) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)packet.title);
            buf.writeVarInt(packet.values.size());
            for (LeaderboardValue value : packet.values) {
                buf.writeUtf(value.username);
                ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)value.value);
                buf.writeByte(value.color.getId());
            }
        }
    };

    public LeaderboardResponsePacket(ServerPlayer requestingPlayer, Leaderboard leaderboard) {
        this(leaderboard.getTitle(), LeaderboardResponsePacket.createValues(requestingPlayer, leaderboard));
    }

    private static ServerStatsCounter loadPlayerStats(MinecraftServer server, UUID uuid) {
        File statsDir = server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
        File statsFile = new File(statsDir, uuid.toString() + ".json");
        return new ServerStatsCounter(server, statsFile);
    }

    private static List<LeaderboardValue> createValues(ServerPlayer requestingPlayer, Leaderboard leaderboard) {
        ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
        ArrayList<PlayerStatsWrapper> players = new ArrayList<PlayerStatsWrapper>();
        PlayerDataTracker tracker = PlayerDataTracker.get(requestingPlayer.server.overworld());
        for (ServerPlayer onlinePlayer : requestingPlayer.server.getPlayerList().getPlayers()) {
            players.add(new PlayerStatsWrapper(onlinePlayer));
        }
        tracker.getAllPlayerUUIDs().forEach(uuid -> {
            GameProfile profile;
            if (requestingPlayer.server.getPlayerList().getPlayer(uuid) == null && (profile = (GameProfile)requestingPlayer.server.getProfileCache().get(uuid).orElse(null)) != null) {
                ServerStatsCounter stats = LeaderboardResponsePacket.loadPlayerStats(requestingPlayer.server, uuid);
                players.add(new PlayerStatsWrapper((UUID)uuid, profile, stats, requestingPlayer.server));
            }
        });
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            PlayerStatsWrapper player = (PlayerStatsWrapper)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = player.getGameProfile().getName();
            value.value = leaderboard.createValue(player);
            value.color = player.getUUID().equals(requestingPlayer.getUUID()) ? ChatFormatting.DARK_GREEN : (!leaderboard.hasValidValue(player) ? ChatFormatting.DARK_GRAY : (i < 3 ? ChatFormatting.GOLD : ChatFormatting.RESET));
            values.add(value);
        }
        return values;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(LeaderboardResponsePacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> Minecraft.getInstance().execute(() -> {
                LeaderboardScreen screen = new LeaderboardScreen(packet.title, packet.values);
                screen.openGui();
            }));
        }
    }
}

