/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.capabilities;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.sirgrantd.magic_coins.MagicCoinsMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CoinsBagCapabilities {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"magic_coins");
    public static final Supplier<AttachmentType<CoinsInBag>> COINS_IN_BAG = ATTACHMENT_TYPES.register("coins_in_bag", () -> AttachmentType.serializable(() -> new CoinsInBag()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MagicCoinsMod.addNetworkMessage(CoinsInBagSyncMessage.TYPE, CoinsInBagSyncMessage.STREAM_CODEC, CoinsInBagSyncMessage::handleData);
    }

    public record CoinsInBagSyncMessage(CoinsInBag data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<CoinsInBagSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"coins_in_bag_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, CoinsInBagSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            CoinsInBagSyncMessage message = new CoinsInBagSyncMessage(new CoinsInBag());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<CoinsInBagSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(CoinsInBagSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((CoinsInBag)context.player().getData(COINS_IN_BAG)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class CoinsInBag
    implements INBTSerializable<CompoundTag> {
        public int valueTotalInCoins = 0;
        public boolean isCoinsLostOnDeath = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("ValueTotalInCoins", this.valueTotalInCoins);
            nbt.putBoolean("IsCoinsLostOnDeath", this.isCoinsLostOnDeath);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.valueTotalInCoins = nbt.getInt("ValueTotalInCoins");
            this.isCoinsLostOnDeath = nbt.getBoolean("IsCoinsLostOnDeath");
        }

        public void syncCoinsInBag(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CoinsInBagSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((CoinsInBag)player2.getData(COINS_IN_BAG)).syncCoinsInBag((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((CoinsInBag)player2.getData(COINS_IN_BAG)).syncCoinsInBag((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((CoinsInBag)player2.getData(COINS_IN_BAG)).syncCoinsInBag((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            CoinsInBag original = (CoinsInBag)event.getOriginal().getData(COINS_IN_BAG);
            CoinsInBag clone = new CoinsInBag();
            clone.valueTotalInCoins = original.valueTotalInCoins;
            clone.isCoinsLostOnDeath = original.isCoinsLostOnDeath;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(COINS_IN_BAG, (Object)clone);
        }
    }
}

