/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.gui.components;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sirgrantd.magic_coins.gui.handlers.HandlerButton;
import net.sirgrantd.magic_coins.init.SoundsInit;

@OnlyIn(value=Dist.CLIENT)
public class CustomButton
extends ImageButton {
    private final AbstractContainerScreen<?> parentGui;
    private final int xOffset;
    private final int yOffset;
    public static final WidgetSprites COLLECT_COINS_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"button_collect_coins"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"button_collect_coins_highlighted"));
    public static final WidgetSprites SILVER_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"silver_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"silver_button_highlighted"));
    public static final WidgetSprites GOLD_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_button_highlighted"));
    public static final WidgetSprites CRYSTAL_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"crystal_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"crystal_button_highlighted"));
    public static final WidgetSprites SILVER_FOR_GOLD_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"silver_for_gold_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"silver_for_gold_button_highlighted"));
    public static final WidgetSprites GOLD_FOR_SILVER_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_for_silver_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_for_silver_button_highlighted"));
    public static final WidgetSprites GOLD_FOR_CRYSTAL_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_for_crystal_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"gold_for_crystal_button_highlighted"));
    public static final WidgetSprites CRYSTAL_FOR_GOLD_ICON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"crystal_for_gold_button"), ResourceLocation.fromNamespaceAndPath((String)"magic_coins", (String)"crystal_for_gold_button_highlighted"));

    public CustomButton(AbstractContainerScreen<?> parentGui, int xOffset, int yOffset, int xIn, int yIn, int widthIn, int heightIn, WidgetSprites sprites, int handlerButton) {
        super(xIn, yIn, widthIn, heightIn, sprites, button -> {
            HandlerButton handler = new HandlerButton(handlerButton);
            handler.ExecuteHandlerButton();
        });
        this.parentGui = parentGui;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsInit.MAGIC_BAG_COLLECT_COINS.get(), (float)1.25f));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setX(this.parentGui.getGuiLeft() + this.xOffset);
        this.setY(this.parentGui.getGuiTop() + this.yOffset);
        AbstractContainerScreen<?> abstractContainerScreen = this.parentGui;
        if (abstractContainerScreen instanceof CreativeModeInventoryScreen) {
            boolean isInventoryTab;
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)abstractContainerScreen;
            this.active = isInventoryTab = creativeScreen.isInventoryOpen();
            if (!isInventoryTab) {
                return;
            }
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

