/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.gui.components;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ImageDisplayRender {
    public static final ResourceLocation DISPLAY_VIEW = ResourceLocation.parse((String)"magic_coins:textures/gui/display_view.png");
    private final AbstractContainerScreen<?> parentGui;
    private final int xOffset;
    private final int yOffset;
    private final ResourceLocation texture;

    public ImageDisplayRender(AbstractContainerScreen<?> parentGui, int xOffset, int yOffset, ResourceLocation texture) {
        this.parentGui = parentGui;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.texture = texture;
    }

    public void renderWidget(GuiGraphics guiGraphics, int sizeX, int sizeY) {
        CreativeModeInventoryScreen creativeScreen;
        boolean isInventoryTab;
        int x = this.parentGui.getGuiLeft() + this.xOffset;
        int y = this.parentGui.getGuiTop() + this.yOffset;
        AbstractContainerScreen<?> abstractContainerScreen = this.parentGui;
        if (abstractContainerScreen instanceof CreativeModeInventoryScreen && !(isInventoryTab = (creativeScreen = (CreativeModeInventoryScreen)abstractContainerScreen).isInventoryOpen())) {
            return;
        }
        guiGraphics.blit(this.texture, x, y, 0.0f, 0.0f, sizeX, sizeY, sizeX, sizeY);
    }
}

