/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.soul_brazier.SoulBrazierBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SoulBindingRecipe;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class SoulBrazierRenderer
implements BlockEntityRenderer<SoulBrazierBlockEntity> {
    public SoulBrazierRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SoulBrazierBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack;
        Vector3f offset;
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        LodestoneBlockEntityInventory inventory = blockEntityIn.inventory;
        LodestoneBlockEntityInventory spiritInventory = blockEntityIn.spiritInventory;
        int spiritsRendered = 0;
        if (!spiritInventory.isEmpty()) {
            for (int i = 0; i < spiritInventory.slotCount; ++i) {
                ItemStack item = spiritInventory.getStackInSlot(i);
                Item item2 = item.getItem();
                if (!(item2 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)item2;
                poseStack.pushPose();
                offset = blockEntityIn.getSpiritOffset(spiritsRendered++, partialTicks).toVector3f();
                poseStack.translate(offset.x(), offset.y(), offset.z());
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, shardItem.getSpiritHolder(), partialTicks);
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
                poseStack.popPose();
            }
        }
        int extrasRendered = 0;
        if (!inventory.isEmpty()) {
            for (int i = 0; i < inventory.slotCount - 1; ++i) {
                ItemStack item = inventory.getStackInSlot(i + 1);
                poseStack.pushPose();
                offset = blockEntityIn.getExtrasOffset(extrasRendered++, partialTicks).toVector3f();
                poseStack.translate(offset.x(), offset.y(), offset.z());
                poseStack.mulPose(Axis.YN.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
                poseStack.popPose();
            }
        }
        if (!(stack = inventory.getStackInSlot(0)).isEmpty()) {
            poseStack.pushPose();
            Vec3 offset2 = SoulBrazierBlockEntity.BRAZIER_ITEM_OFFSET;
            poseStack.translate(offset2.x, offset2.y, offset2.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)level.getGameTime() + partialTicks) * 3.0f % 360.0f));
            poseStack.scale(0.55f, 0.55f, 0.55f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
        if (blockEntityIn.isActive()) {
            double yOffset;
            double xOffset;
            double angle;
            int i;
            SoulBindingRecipe recipe = blockEntityIn.recipe;
            List<SpiritIngredient> spirits = recipe.spirits;
            GeasEffectType geas = recipe.result;
            ResourceLocation texture = geas.getIcon();
            LodestoneRenderTypeBuilder additive = LodestoneRenderTypes.ADDITIVE_DISTORTED_TEXTURE.apply(RenderTypeToken.createToken((ResourceLocation)texture));
            LodestoneRenderTypeBuilder transparent = LodestoneRenderTypes.TRANSPARENT_DISTORTED_TEXTURE.apply(RenderTypeToken.createToken((ResourceLocation)texture));
            Vec3 offset3 = SoulBrazierBlockEntity.BRAZIER_GEAS_ICON_OFFSET;
            float progress = (float)blockEntityIn.progress + partialTicks;
            float alpha = 0.9f * Math.clamp(progress / 5.0f, 0.0f, 1.0f);
            float scale = 0.4f * Math.min(1.0f + progress / 10.0f, 2.0f);
            VFXBuilders.WorldVFXBuilder worldVFXBuilder = VFXBuilders.createWorld();
            AtomicInteger cycle = new AtomicInteger();
            Function<Function, Color> colorSupplier = b -> (Color)b.apply((SpiritLike)spirits.get(cycle.getAndIncrement() % spirits.size()));
            Color mainColor = colorSupplier.apply(SpiritLike::getPrimaryColor);
            poseStack.pushPose();
            poseStack.translate(offset3.x, offset3.y, offset3.z);
            poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            int interval = 160;
            float gameTime = (float)level.getGameTime() + partialTicks;
            float distance = scale * 0.08f;
            worldVFXBuilder.setColor(colorSupplier.apply(SpiritLike::getPrimaryColor)).multiplyColor(0.32f).setRenderType(transparent).setAlpha(alpha * 0.4f).renderQuad(poseStack, scale);
            for (i = 0; i < 4; ++i) {
                angle = (float)i * 1.57f;
                xOffset = (double)distance * Math.cos(angle += (double)(gameTime % (float)interval / (float)interval * 6.28f));
                yOffset = (double)distance * Math.sin(angle);
                poseStack.translate(xOffset, yOffset, -0.02 * (double)i);
                worldVFXBuilder.setColor(colorSupplier.apply(SpiritLike::getPrimaryColor)).multiplyColor(0.32f).renderQuad(poseStack, scale);
                poseStack.translate(-xOffset, -yOffset, 0.02 * (double)i);
            }
            worldVFXBuilder.replaceBufferSource(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColor(mainColor).setRenderType(additive).setAlpha(alpha * 0.8f).renderQuad(poseStack, scale);
            for (i = 0; i < 4; ++i) {
                angle = (float)i * 1.57f;
                xOffset = (double)distance * Math.cos(angle += (double)(gameTime % (float)interval / (float)interval * 6.28f));
                yOffset = (double)distance * Math.sin(angle);
                poseStack.translate(xOffset, yOffset, 0.0);
                worldVFXBuilder.setAlpha(alpha * 0.4f).setColor(colorSupplier.apply(SpiritLike::getSecondaryColor)).renderQuad(poseStack, scale);
                poseStack.translate(-xOffset, -yOffset, 0.0);
            }
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(SoulBrazierBlockEntity altar) {
        BlockPos pos = altar.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }
}

