/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.scythe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class ScytheBoomerangEntityRenderer
extends EntityRenderer<ScytheBoomerangEntity> {
    public final ItemRenderer itemRenderer;

    public ScytheBoomerangEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ScytheBoomerangEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        SpiritLike spiritLike;
        poseStack.pushPose();
        ItemStack itemstack = entityIn.getItem();
        BakedModel model = this.itemRenderer.getModel(itemstack, entityIn.level(), null, 1);
        if (entityIn.isNarrow()) {
            Vec3 direction = entityIn.getDeltaMovement().normalize();
            float yRot = (float)Mth.atan2((double)direction.x, (double)direction.z);
            poseStack.mulPose(Axis.YP.rotation(yRot + 1.57f));
        } else {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        poseStack.mulPose(Axis.ZP.rotation(((float)entityIn.age + partialTicks) * 0.9f));
        poseStack.scale(2.0f, 2.0f, 1.5f);
        this.itemRenderer.render(itemstack, itemstack.getItem() instanceof MalumScytheItem ? ItemDisplayContext.NONE : ItemDisplayContext.FIXED, false, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        Item item = entityIn.getItem().getItem();
        if (item instanceof ISpiritAffiliatedItem) {
            ISpiritAffiliatedItem affiliatedItem = (ISpiritAffiliatedItem)item;
            spiritLike = affiliatedItem.getDefiningSpiritType();
        } else {
            spiritLike = null;
        }
        SpiritLike spirit = spiritLike;
        boolean isMagical = spirit != null;
        LodestoneRenderTypeBuilder renderType = isMagical ? LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL) : LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT);
        Color primaryColor = isMagical ? spirit.getPrimaryColor() : new Color(0.9f, 0.9f, 0.9f);
        Color secondaryColor = isMagical ? spirit.getSecondaryColor() : new Color(0.5f, 0.5f, 0.5f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(renderType);
        float scalar = Math.min((float)entityIn.age / 20.0f, 1.0f);
        RenderUtils.renderEntityTrail(poseStack, builder, entityIn.theFormer, (Entity)entityIn, primaryColor, secondaryColor, scalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, entityIn.theLatter, (Entity)entityIn, primaryColor, secondaryColor, scalar, partialTicks);
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ScytheBoomerangEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

