/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.entries;

import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.PlacedEntryAcceptor;
import com.sammy.malum.client.screen.codex.WidgetDesignType;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.SubspaceEntryObject;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.pages.recipe.SoulBindingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.recipe.vanilla.CraftingPage;
import com.sammy.malum.client.screen.codex.pages.text.GeasInfoPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextItemPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.text.TextPage;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ArcanaProgressionScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GeasEntries {
    public static void setupEntries(ArcanaProgressionScreen screen) {
        Item EMPTY = ItemStack.EMPTY.getItem();
        screen.addEntry("geas_magic", 0, 9, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.SOUL_BRAZIER)).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextPage("geas_magic", "geas_magic.1")).addPage(new CraftingPage((Item)MalumItems.SOUL_BRAZIER.get(), (Item)MalumItems.HALLOWED_GOLD_INGOT.get(), (Item)MalumItems.CTHONIC_GOLD.get(), (Item)MalumItems.HALLOWED_GOLD_INGOT.get(), (Item)MalumItems.RUNEWOOD_PLANKS.get(), (Item)MalumItems.RUNEWOOD_PLANKS.get(), (Item)MalumItems.RUNEWOOD_PLANKS.get(), (Item)MalumItems.TAINTED_ROCK.get(), (Item)MalumItems.RUNEWOOD_PLANKS.get(), (Item)MalumItems.TAINTED_ROCK.get())).addPage(new TextPage("geas_magic.2")).addPage(new TextPage("geas_magic.3")).addPage(new TextPage("geas_magic.4")).addPage(new TextPage("geas_magic.5")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.PARACAUSAL_FLAME, BookEntry.create("undoing_geas_bindings").addPage(new HeadlineTextItemPage("undoing_geas_bindings", "undoing_geas_bindings.1", (Item)MalumItems.PARACAUSAL_FLAME.get())).addPage(new TextPage("undoing_geas_bindings.2")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.PARACAUSAL_FLAME.get())))));
        GeasEntries.addBundledGeasEntry(screen, "pacts_of_an_uneven_conscience", 2, 10, new Holder[]{MalumGeasEffectTypes.PACT_OF_DEFIANCE, MalumGeasEffectTypes.PACT_OF_THE_PARASITE, MalumGeasEffectTypes.PACT_OF_THE_WARLOCK, MalumGeasEffectTypes.PACT_OF_THE_REAPER});
        GeasEntries.addBundledGeasEntry(screen, "pacts_of_an_inward_soul", -2, 10, new Holder[]{MalumGeasEffectTypes.PACT_OF_THE_FORTRESS, MalumGeasEffectTypes.PACT_OF_THE_SHIELD, MalumGeasEffectTypes.PACT_OF_THE_SHATTERING_ADDICT, MalumGeasEffectTypes.PACT_OF_THE_ARCANAPHAGE});
        GeasEntries.addBundledGeasEntry(screen, "pacts_of_an_unbound_wayfarer", 4, 11, new Holder[]{MalumGeasEffectTypes.PACT_OF_SELF_CARE, MalumGeasEffectTypes.PACT_OF_THE_HIGH_PRIEST, MalumGeasEffectTypes.PACT_OF_THE_WINDSWEPT, MalumGeasEffectTypes.PACT_OF_THE_CONTINUING_SHOT});
        GeasEntries.addBundledGeasEntry(screen, "pacts_of_an_igneous_shaper", -4, 11, new Holder[]{MalumGeasEffectTypes.PACT_OF_CONTENTEDNESS, MalumGeasEffectTypes.PACT_OF_THE_LONE_DRUID, MalumGeasEffectTypes.PACT_OF_COMBUSTION, MalumGeasEffectTypes.PACT_OF_THE_PROSPECTOR});
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_LIFEWEAVER, 15, 14);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_BERSERKER, 14, 15);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_SKYBREAKER, 13, 17);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER, 15, 16);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_TIDAL_AFFINITY, 14, 18);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_PATIENCE_REPAID, 16, 17);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_RECIPROCATION, -15, 14);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_RUNE_EXPLOITATION, -14, 15);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_PROFANE_ASCETIC, -13, 17);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_PROFANE_GLUTTON, -15, 16);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_WYRD_RECONSTRUCTION, -14, 18);
        GeasEntries.addGeasEntry(screen, MalumGeasEffectTypes.PACT_OF_THE_BLASTWEAVER, -16, 17);
    }

    @SafeVarargs
    public static void addBundledGeasEntry(AbstractProgressionCodexScreen screen, String name, int x, int y, Holder<GeasEffectType> ... geasa) {
        SpiritHolder<SpiritArcanaType> definingSpirit = ((GeasEffectType)geasa[0].value()).spiritTypes.getFirst();
        SubspaceEntryObject.SubspaceWidgetSupplier acceptor = new SubspaceEntryObject.SubspaceWidgetSupplier();
        int horizontalOffset = x > 0 ? 1 : -1;
        GeasEntries.addGeasEntry(acceptor, geasa[0], x - horizontalOffset, y);
        GeasEntries.addGeasEntry(acceptor, geasa[1], x, y + 1);
        GeasEntries.addGeasEntry(acceptor, geasa[2], x, y - 1);
        GeasEntries.addGeasEntry(acceptor, geasa[3], x + horizontalOffset, y);
        screen.addEntry(name, x, y, b -> b.setWidgetSupplier(acceptor).configureWidget(w -> w.setDesign(WidgetDesignType.SUBENTRY, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).setAssociatedSpirit(definingSpirit));
    }

    public static void addGeasEntry(PlacedEntryAcceptor acceptor, Holder<GeasEffectType> geas, int x, int y) {
        acceptor.addEntry(((GeasEffectType)geas.value()).getRegistryName().getPath(), x, y, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Holder)geas)).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).setAssociatedSpirit(((GeasEffectType)geas.value()).getIdentifyingSpirit()).addPage(SoulBindingPage.fromGeas(geas)).addPage(new GeasInfoPage(geas)));
    }

    public static void addSoulwoodGeasEntry(PlacedEntryAcceptor acceptor, Holder<GeasEffectType> geas, int x, int y) {
        acceptor.addEntry(((GeasEffectType)geas.value()).getRegistryName().getPath(), x, y, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Holder)geas)).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage(SoulBindingPage.fromGeas(geas)).addPage(new GeasInfoPage(geas)));
    }
}

