/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.handlers;

import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.handlers.BookObjectHandler;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.SubspaceEntryObject;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class EntryObjectHandler
extends BookObjectHandler<AbstractProgressionCodexScreen> {
    protected final HashMap<PlacedBookEntry, ProgressionEntryObject> entryObjectMap = new HashMap();

    public void setupEntryObjects(AbstractProgressionCodexScreen screen) {
        this.setupEntryObjects(screen, (List<PlacedBookEntry>)screen.getEntries());
    }

    public void setupEntryObjects(AbstractProgressionCodexScreen screen, List<PlacedBookEntry> entries) {
        this.objects.clear();
        this.entryObjectMap.clear();
        ArrayList<ProgressionEntryObject> objects = new ArrayList<ProgressionEntryObject>();
        ArrayList<SubspaceEntryObject> subspaceObjects = new ArrayList<SubspaceEntryObject>();
        for (PlacedBookEntry entry : entries) {
            PlacedBookEntry.BookEntryWidgetPlacementData data = entry.getWidgetData();
            ProgressionEntryObject bookObject = data.widgetSupplier().getBookObject(entry, data.xOffset(), -data.yOffset());
            Consumer<ProgressionEntryObject> config = data.widgetConfig();
            if (config != null) {
                config.accept(bookObject);
            }
            if (bookObject instanceof SubspaceEntryObject) {
                SubspaceEntryObject subspaceObject = (SubspaceEntryObject)bookObject;
                subspaceObjects.add(subspaceObject);
                continue;
            }
            objects.add(bookObject);
            this.entryObjectMap.put(entry, bookObject);
        }
        this.addAll(subspaceObjects);
        this.addAll(objects);
    }

    public ProgressionEntryObject getOriginObject() {
        for (BookObject object : this.objects) {
            if (!(object instanceof ProgressionEntryObject)) continue;
            ProgressionEntryObject progressionEntryObject = (ProgressionEntryObject)object;
            if (!progressionEntryObject.isOrigin) continue;
            return progressionEntryObject;
        }
        return null;
    }

    public ProgressionEntryObject getObject(String entryName) {
        for (PlacedBookEntry entry : this.entryObjectMap.keySet()) {
            if (!entry.identifier.equals(entryName)) continue;
            return this.entryObjectMap.get(entry);
        }
        return null;
    }

    public ProgressionEntryObject getObject(PlacedBookEntry entry) {
        return this.entryObjectMap.get(entry);
    }
}

