/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class CodexItemHelper {
    public static void renderIngredient(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, ICustomIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, ingredient.getItems().toList(), posX, posY, mouseX, mouseY);
    }

    public static void renderIngredient(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, SizedIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderIngredient(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, ICustomIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, ingredient.getItems().toList(), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, SizedIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        CodexItemHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, List<ItemStack> stacks, int posX, int posY, int mouseX, int mouseY) {
        if (stacks.isEmpty()) {
            return;
        }
        if (stacks.size() == 1) {
            CodexItemHelper.renderItem(screen, guiGraphics, stacks.getFirst(), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(Minecraft.getInstance().level.getGameTime() % (20L * (long)stacks.size()) / 20L);
        ItemStack stack = stacks.get(index);
        CodexItemHelper.renderItem(screen, guiGraphics, stack, posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        if (!stack.isEmpty()) {
            guiGraphics.renderItem(stack, posX, posY);
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, posX, posY, null);
            if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
                screen.renderLater(() -> guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), mouseX, mouseY));
            }
        }
    }

    public static void renderIngredients(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, List<?> ingredients, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<List<ItemStack>> stackBundles = Stream.of(ingredients.stream().filter(o -> o instanceof ICustomIngredient).map(o -> ((ICustomIngredient)o).getItems().toList()), ingredients.stream().filter(o -> o instanceof SizedIngredient).map(o -> Arrays.stream(((SizedIngredient)o).getItems()).toList()), ingredients.stream().filter(o -> o instanceof Ingredient).map(o -> Arrays.stream(((Ingredient)o).getItems()).toList())).flatMap(s -> s).toList();
        CodexItemHelper.renderItemList(screen, guiGraphics, stackBundles, left, top, mouseX, mouseY, vertical);
    }

    public static void renderItemList(AbstractMalumCodexScreen screen, GuiGraphics guiGraphics, List<List<ItemStack>> items, int left, int top, int mouseX, int mouseY, boolean isVertical) {
        int slots = items.size();
        int startingOffset = 9 * (slots - 1);
        CodexItemHelper.renderItemFrames(guiGraphics, slots, left, top, isVertical);
        if (isVertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = 0; i < slots; ++i) {
            List<ItemStack> list = items.get(i);
            int offset = i * 18;
            int oLeft = left + (isVertical ? 0 : offset);
            int oTop = top + (isVertical ? offset : 0);
            CodexItemHelper.renderItem(screen, guiGraphics, list, oLeft, oTop, mouseX, mouseY);
        }
    }

    public static void renderItemFrames(GuiGraphics guiGraphics, int slots, int left, int top, boolean isVertical) {
        PoseStack poseStack = guiGraphics.pose();
        int startingOffset = 9 * (slots - 1);
        if (isVertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = slots - 1; i >= 0; --i) {
            int offset = i * 18;
            int u = isVertical ? 0 : 2;
            int v = isVertical ? 2 : 0;
            int oLeft = left - 1 + (isVertical ? -2 : offset);
            int oTop = top - 1 + (isVertical ? offset : -2);
            int width = isVertical ? 22 : 18;
            int height = isVertical ? 18 : 22;
            CodexRenderHelper.renderTexture(CodexEntryScreen.ITEM_SOCKET, poseStack, oLeft, (float)oTop, (float)u, (float)v, width, height, 64, 64);
        }
        if (isVertical) {
            CodexRenderHelper.renderTexture(CodexEntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 3), 0.0f, 0.0f, 22, 2, 64, 64);
            CodexRenderHelper.renderTexture(CodexEntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 1 + 18 * slots), 0.0f, 20.0f, 22, 2, 64, 64);
        } else {
            CodexRenderHelper.renderTexture(CodexEntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 3), 0.0f, 0.0f, 2, 22, 64, 64);
            CodexRenderHelper.renderTexture(CodexEntryScreen.ITEM_SOCKET, poseStack, left - 1 + 18 * slots, (float)(top - 3), 20.0f, 0.0f, 2, 22, 64, 64);
        }
    }
}

