/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.config.ClientConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;

public class CodexTextHelper {
    public static final Function<GuiGraphics, LodestoneBufferWrapper> WRAPPER_FUNCTION = Util.memoize(guiGraphics -> new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)guiGraphics.bufferSource));
    public static final TextColorData DEFAULT_TEXT_COLOR = new TextColorData(new Color(138, 79, 58), new Color(65, 41, 8), new Color(20, 44, 60), new Color(227, 39, 228));
    public static final TextColorData GEAS_POSITIVE_COLOR = new TextColorData(new Color(18, 52, 141), new Color(118, 52, 141), new Color(20, 44, 120), new Color(100, 100, 240));
    public static final TextColorData GEAS_NEGATIVE_COLOR = new TextColorData(new Color(141, 18, 52), new Color(118, 52, 141), new Color(120, 44, 20), new Color(240, 100, 100));

    public static void renderWrappingText(GuiGraphics guiGraphics, String text, float x, float y, int width) {
        CodexTextHelper.renderWrappingText(guiGraphics, (Component)Component.translatable((String)text), x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, Component text, float x, float y, int width) {
        CodexTextHelper.renderWrappingText(guiGraphics, DEFAULT_TEXT_COLOR, text, x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, String text, float x, float y, int width) {
        CodexTextHelper.renderWrappingText(guiGraphics, colorData, (Component)Component.translatable((String)text), x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, Component text, float x, float y, int width) {
        float scale = 1.0f;
        String translated = text.getString();
        if (translated.startsWith("$m")) {
            int i = translated.indexOf("/$");
            float value = Float.parseFloat(translated.substring(3, i));
            text = Component.literal((String)translated.substring(i + 2));
            scale = value;
        }
        CodexTextHelper.renderWrappingText(guiGraphics, colorData, text, x, y, width, scale);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, Component text, float x, float y, int width, float scaleMultiplier) {
        Font font = Minecraft.getInstance().font;
        List<String> wrapped = CodexTextHelper.wrapText(text, (int)((float)width / scaleMultiplier));
        for (int i = 0; i < wrapped.size(); ++i) {
            String currentLine = wrapped.get(i);
            float textX = x;
            float textY = y;
            if (scaleMultiplier != 1.0f) {
                textX /= scaleMultiplier;
                textY /= scaleMultiplier;
            }
            Objects.requireNonNull(font);
            CodexTextHelper.renderRawText(guiGraphics, colorData, currentLine, textX, textY + (float)(i * (9 + 1)), 0.2f, scaleMultiplier);
        }
    }

    public static void renderHeadline(GuiGraphics graphics, Component component, int left, int top) {
        int width = Minecraft.getInstance().font.width(component.getString());
        float scale = 1.0f;
        if (width > 100) {
            scale -= (float)(width - 100) / 200.0f;
        }
        float textLeft = left + 72;
        float textTop = top + 5;
        if (scale != 1.0f) {
            textLeft /= scale;
            textTop /= scale;
            textTop += 5.0f * (1.0f - scale);
        }
        CodexTextHelper.renderText(graphics, component, textLeft - (float)width / 2.0f, textTop, scale);
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, float x, float y) {
        CodexTextHelper.renderText(guiGraphics, DEFAULT_TEXT_COLOR, component, x, y, 0.4f);
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, float x, float y, float scale) {
        CodexTextHelper.renderRawText(guiGraphics, DEFAULT_TEXT_COLOR, component.getString(), x, y, 0.4f, scale);
    }

    public static void renderText(GuiGraphics guiGraphics, TextColorData colorData, Component component, float x, float y, float glow) {
        CodexTextHelper.renderText(guiGraphics, colorData, component, x, y, glow, 1.0f);
    }

    public static void renderText(GuiGraphics guiGraphics, TextColorData colorData, Component component, float x, float y, float glow, float scale) {
        String text = component.getString();
        CodexTextHelper.renderRawText(guiGraphics, colorData, text, x, y, glow, scale);
    }

    private static void renderRawText(GuiGraphics guiGraphics, TextColorData colorData, String text, float x, float y, float glowMultiplier, float scaleMultiplier) {
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        Font font = minecraft.font;
        float guiScale = (float)minecraft.getWindow().getGuiScale();
        float inverseScale = 4.0f / guiScale * 4.0f * scaleMultiplier;
        float width = (float)font.width(text) / 2.0f;
        float screenWidth = minecraft.getWindow().getScreenWidth();
        float screenHeight = minecraft.getWindow().getScreenHeight();
        float mouseX = (float)(minecraft.mouseHandler.xpos() / (double)screenWidth);
        float mouseY = (float)(minecraft.mouseHandler.ypos() / (double)screenHeight);
        Objects.requireNonNull(font);
        float lineHeight = 9.0f;
        if (scaleMultiplier != 1.0f) {
            poseStack.pushPose();
            poseStack.scale(scaleMultiplier, scaleMultiplier, 1.0f);
            mouseX /= scaleMultiplier;
            mouseY /= scaleMultiplier;
        }
        float textX = (x + width) * guiScale / screenWidth;
        float textY = (y + lineHeight) * guiScale / screenHeight;
        float differenceX = textX - mouseX;
        float differenceY = textY - mouseY;
        double horizontalDelta = Math.clamp(1.0f - Mth.abs((float)differenceX) * inverseScale, 0.0f, 1.0f);
        double verticalDelta = Math.clamp(1.0f - Mth.abs((float)differenceY) * inverseScale, 0.0f, 1.0f);
        if (differenceY > 0.0f) {
            verticalDelta = Math.pow(verticalDelta * (double)(1.0f - differenceY), 3.0);
        }
        double delta = Easing.QUINTIC_OUT.ease(horizontalDelta, 0.0, 1.0) * Easing.QUINTIC_OUT.ease(verticalDelta, 0.0, 1.0);
        if (CodexEntryScreen.textJump > 0.0f) {
            double jumpDelta = delta * (double)Easing.SINE_IN_OUT.ease(CodexEntryScreen.textJump, 0.0f, 1.0f);
            glowMultiplier *= (float)(1.0 + jumpDelta);
        }
        if (((BookTheme)((Object)ClientConfig.BOOK_THEME.getConfigValue())).equals((Object)BookTheme.EASY_READING)) {
            Color color = colorData.secondaryColor();
            guiGraphics.drawString(font, text, x, y, 0, false);
            font.drawInBatch(text, x, y, FastColor.ARGB32.color((int)1, (int)color.getRGB()), false, poseStack.last().pose(), (MultiBufferSource)guiGraphics.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
        } else {
            Color gray = colorData.primaryColor();
            Color dark = colorData.secondaryColor();
            guiGraphics.drawString(font, text, x - 1.0f, y, FastColor.ARGB32.color((int)64, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x + 1.0f, y, FastColor.ARGB32.color((int)32, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y - 1.0f, FastColor.ARGB32.color((int)32, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y + 1.0f, FastColor.ARGB32.color((int)92, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y, FastColor.ARGB32.color((int)255, (int)dark.getRGB()), false);
            int alpha = Mth.floor((float)(255.0f * Easing.QUARTIC_IN.ease(delta, (double)0.4f, 1.0, 1.0) * glowMultiplier));
            if (alpha > 15) {
                float color = Easing.CUBIC_IN.ease(delta, 0.0, 1.0, 1.0);
                Color start = colorData.glowStart();
                Color end = colorData.glowEnd();
                int r = (int)Mth.lerp((float)color, (float)start.getRed(), (float)end.getRed());
                int g = (int)Mth.lerp((float)color, (float)start.getGreen(), (float)end.getGreen());
                int b = (int)Mth.lerp((float)color, (float)start.getBlue(), (float)end.getBlue());
                LodestoneBufferWrapper buffer = WRAPPER_FUNCTION.apply(guiGraphics);
                Matrix4f pose = poseStack.last().pose();
                RenderSystem.enableBlend();
                font.drawInBatch(text, x, y, FastColor.ARGB32.color((int)alpha, (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x + 1.0f, y, FastColor.ARGB32.color((int)(alpha / 2), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x - 1.0f, y, FastColor.ARGB32.color((int)(alpha / 3), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x, y + 1.0f, FastColor.ARGB32.color((int)(alpha / 2), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x, y - 1.0f, FastColor.ARGB32.color((int)(alpha / 3), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                RenderSystem.defaultBlendFunc();
            }
        }
        if (scaleMultiplier != 1.0f) {
            poseStack.popPose();
        }
    }

    public static MutableComponent convertToComponent(String text) {
        return CodexTextHelper.convertToComponent(text, UnaryOperator.identity());
    }

    public static MutableComponent convertToComponent(String text, UnaryOperator<Style> styleModifier) {
        text = Component.translatable((String)text).getString();
        MutableComponent raw = Component.empty();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char peek;
            char chr = text.charAt(i);
            if (chr == '$') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            line.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                line.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    if (peek == '$') {
                        line = CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        ++i;
                        continue;
                    }
                    line.append(chr);
                    continue;
                }
                line.append(chr);
                continue;
            }
            line.append(chr);
        }
        CodexTextHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
        return raw;
    }

    public static List<Component> wrapComponent(Component source, MutableComponent header, int width) {
        List<MutableComponent> wrapped = CodexTextHelper.wrapText(source, width).stream().map(Component::literal).toList();
        ArrayList<Component> result = new ArrayList<Component>();
        for (MutableComponent mutableComponent : wrapped) {
            result.add((Component)header.copy().append((Component)mutableComponent.setStyle(source.getStyle())));
        }
        return result;
    }

    public static List<Component> wrapComponent(Component source, int width) {
        return CodexTextHelper.wrapText(source, width).stream().map(Component::literal).peek(component -> component.setStyle(source.getStyle())).map(Component.class::cast).toList();
    }

    public static List<String> wrapText(Component component, int width) {
        Font font = Minecraft.getInstance().font;
        String text = component.getString() + "\n";
        ArrayList<String> lines = new ArrayList<String>();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr == ' ' || chr == '\n') {
                if (!word.isEmpty()) {
                    if (font.width(line.toString()) + font.width(word.toString()) > width) {
                        line = CodexTextHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                    }
                    line.append((CharSequence)word).append(' ');
                    word = new StringBuilder();
                }
                String noFormatting = ChatFormatting.stripFormatting((String)line.toString());
                if (chr != '\n' || noFormatting == null) continue;
                line = CodexTextHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                continue;
            }
            if (chr == '$') {
                if (i != text.length() - 1) {
                    char peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            word.append(ChatFormatting.ITALIC);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            word.append(ChatFormatting.BOLD);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            word.append(ChatFormatting.STRIKETHROUGH);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            word.append(ChatFormatting.UNDERLINE);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            word.append(ChatFormatting.OBFUSCATED);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            word.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                word.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    char peek = text.charAt(i + 1);
                    if (peek == '$') {
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        word.append(ChatFormatting.RESET);
                        ++i;
                        continue;
                    }
                    word.append(chr);
                    continue;
                }
                word.append(chr);
                continue;
            }
            word.append(chr);
        }
        return lines;
    }

    private static StringBuilder commitComponent(MutableComponent component, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line, UnaryOperator<Style> styleModifier) {
        component.append((Component)Component.literal((String)line.toString()).withStyle(style -> style.withItalic(Boolean.valueOf(italic)).withBold(Boolean.valueOf(bold)).withStrikethrough(Boolean.valueOf(strikethrough)).withUnderlined(Boolean.valueOf(underline)).withObfuscated(Boolean.valueOf(obfuscated))).withStyle(styleModifier));
        line = new StringBuilder();
        return line;
    }

    private static StringBuilder newLine(List<String> lines, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line) {
        lines.add(line.toString());
        line = new StringBuilder();
        if (italic) {
            line.append(ChatFormatting.ITALIC);
        }
        if (bold) {
            line.append(ChatFormatting.BOLD);
        }
        if (strikethrough) {
            line.append(ChatFormatting.STRIKETHROUGH);
        }
        if (underline) {
            line.append(ChatFormatting.UNDERLINE);
        }
        if (obfuscated) {
            line.append(ChatFormatting.OBFUSCATED);
        }
        return line;
    }

    public record TextColorData(Color primaryColor, Color secondaryColor, Color glowStart, Color glowEnd) {
    }

    public static enum BookTheme {
        DEFAULT,
        EASY_READING;

    }
}

