/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block;

import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;

public class MalumBlockEntityInventory
extends LodestoneBlockEntityInventory {
    public static MalumBlockEntityInventory singleItem(LodestoneBlockEntity blockEntity) {
        return new MalumBlockEntityInventory(blockEntity, 1, 1);
    }

    public static MalumBlockEntityInventory singleItemStack(LodestoneBlockEntity blockEntity) {
        return new MalumBlockEntityInventory(blockEntity, 1, 64);
    }

    public static MalumBlockEntityInventory singleNotSpirit(LodestoneBlockEntity blockEntity) {
        return new MalumBlockEntityInventory(blockEntity, 1, 1).setInputPredicate(p -> !p.is(MalumTags.ItemTags.SPIRITS));
    }

    public static MalumBlockEntityInventory singleStackNotSpirit(LodestoneBlockEntity blockEntity) {
        return new MalumBlockEntityInventory(blockEntity, 1, 64).setInputPredicate(p -> !p.is(MalumTags.ItemTags.SPIRITS));
    }

    public static MalumBlockEntityInventory items(LodestoneBlockEntity blockEntity, int slotCount) {
        return new MalumBlockEntityInventory(blockEntity, slotCount, 1);
    }

    public static MalumBlockEntityInventory itemStacks(LodestoneBlockEntity blockEntity, int slotCount) {
        return new MalumBlockEntityInventory(blockEntity, slotCount, 64);
    }

    public static MalumBlockEntityInventory notSpirits(LodestoneBlockEntity blockEntity, int slotCount) {
        return new MalumBlockEntityInventory(blockEntity, slotCount, 1).setInputPredicate(p -> !p.is(MalumTags.ItemTags.SPIRITS));
    }

    public static MalumBlockEntityInventory stacksNotSpirits(LodestoneBlockEntity blockEntity, int slotCount) {
        return new MalumBlockEntityInventory(blockEntity, slotCount, 64).setInputPredicate(p -> !p.is(MalumTags.ItemTags.SPIRITS));
    }

    protected MalumBlockEntityInventory(LodestoneBlockEntity blockEntity, int slotCount, int allowedItemSize) {
        super(blockEntity, slotCount, allowedItemSize);
        this.triggerBlockEntityUpdate();
    }

    public MalumBlockEntityInventory setInputPredicate(Predicate<ItemStack> inputPredicate) {
        return (MalumBlockEntityInventory)super.setInputPredicate(inputPredicate);
    }

    public void giveItemToPlayer(Player playerEntity, ItemStack stack, int slot) {
        super.giveItemToPlayer(playerEntity, stack, slot);
        SoundEvent soundEvent = this.getExtractSound(stack);
        this.playSound(playerEntity, soundEvent, stack);
    }

    public ItemStack takeItemFromPlayer(Player playerEntity, ItemStack stack) {
        ItemStack result = super.takeItemFromPlayer(playerEntity, stack);
        if (!result.isEmpty()) {
            SoundEvent soundEvent = this.getInsertSound(result);
            this.playSound(playerEntity, soundEvent, result);
        }
        return result;
    }

    public void playSound(Player player, SoundEvent soundEvent, ItemStack stack) {
        SoundHelper.playSound((Entity)player, (SoundEvent)soundEvent, (SoundSource)SoundSource.BLOCKS, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)player.getRandom(), (float)1.0f, (float)1.2f));
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            SoundType soundType = block.getSoundType(block.defaultBlockState(), (LevelReader)player.level(), this.blockEntity.getBlockPos(), (Entity)player);
            SoundHelper.playSound((Entity)player, (SoundEvent)soundType.getHitSound(), (SoundSource)SoundSource.BLOCKS, (float)(soundType.getVolume() * 0.4f), (float)(soundType.getVolume() * RandomHelper.randomBetween((RandomSource)player.getRandom(), (float)1.2f, (float)1.4f)));
        }
    }

    public SoundEvent getExtractSound(ItemStack stack) {
        return stack.getItem() instanceof SpiritShardItem ? (SoundEvent)MalumSoundEvents.PEDESTAL_SPIRIT_PICKUP.get() : (SoundEvent)MalumSoundEvents.PEDESTAL_ITEM_PICKUP.get();
    }

    public SoundEvent getInsertSound(ItemStack stack) {
        return stack.getItem() instanceof SpiritShardItem ? (SoundEvent)MalumSoundEvents.PEDESTAL_SPIRIT_INSERT.get() : (SoundEvent)MalumSoundEvents.PEDESTAL_ITEM_INSERT.get();
    }
}

