/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.data.map.TotemPoleMap;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumDataMaps;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.systems.block.LodestoneLogBlock;

public class MalumLogBLock
extends LodestoneLogBlock {
    public MalumLogBLock(BlockBehaviour.Properties properties, Supplier<Block> stripped) {
        super(properties, stripped);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem shard = (SpiritShardItem)item;
            if (hit.getDirection().equals((Object)Direction.UP) || hit.getDirection().equals((Object)Direction.DOWN)) {
                return ItemInteractionResult.FAIL;
            }
            if (((Direction.Axis)state.getValue((Property)AXIS)).isHorizontal()) {
                return ItemInteractionResult.FAIL;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.createTotemPole(serverLevel, pos, hit.getDirection(), shard)) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hit);
    }

    public boolean createTotemPole(ServerLevel level, BlockPos pos, Direction direction, SpiritLike spirit) {
        if (spirit.matches(MalumSpiritTypes.UMBRAL_SPIRIT)) {
            return false;
        }
        TotemPoleMap conversion = (TotemPoleMap)this.builtInRegistryHolder().getData(MalumDataMaps.TOTEM_POLE_CONVERSION);
        if (conversion == null) {
            return false;
        }
        Block converted = (Block)conversion.totemPoleVariant().value();
        if (converted instanceof TotemPoleBlock) {
            TotemPoleBlock totemPoleBlock = (TotemPoleBlock)converted;
            level.setBlockAndUpdate(pos, TotemPoleBlock.createTotemPoleState(totemPoleBlock, direction, spirit));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TotemPoleBlockEntity) {
                TotemPoleBlockEntity blockEntity2 = (TotemPoleBlockEntity)blockEntity;
                blockEntity2.brieflyActivate(level);
            }
            level.levelEvent(2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
        }
        return false;
    }
}

