/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.SoundHelper;

public class MalignantInfluenceData {
    public static Codec<MalignantInfluenceData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.INT.optionalFieldOf("malignantAegis", (Object)0).forGetter(MalignantInfluenceData::getMalignantAegis), (App)Codec.INT.optionalFieldOf("aegisCooldown", (Object)0).forGetter(MalignantInfluenceData::getMalignantAegis)).apply((Applicative)obj, MalignantInfluenceData::new));
    public static StreamCodec<ByteBuf, MalignantInfluenceData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    protected final HashMap<Holder<Attribute>, Double> cachedAttributeValues = new HashMap();
    protected int malignantAegis;
    protected int aegisCooldown;
    protected boolean isDirty;

    public MalignantInfluenceData() {
    }

    public MalignantInfluenceData(int malignantAegis, int aegisCooldown) {
        this.malignantAegis = malignantAegis;
        this.aegisCooldown = aegisCooldown;
    }

    public void tickData(LivingEntity entity) {
        int limit = MalignantInfluenceData.getMalignantAegisCapacity(entity);
        if (this.getMalignantAegis() < limit) {
            if (this.aegisCooldown > 0) {
                --this.aegisCooldown;
            }
            if (this.aegisCooldown <= 0) {
                this.recoverAegis(entity, 1.0);
            }
        }
        if (this.getMalignantAegis() > limit) {
            this.setAegis(limit);
        }
        if (this.isDirty) {
            if (!entity.level().isClientSide) {
                entity.syncData(MalumAttachmentTypes.MALIGNANT_INFLUENCE);
            }
            this.isDirty = false;
        }
    }

    public void recoverAegis(LivingEntity entity, double amount) {
        AttributeInstance capacity = entity.getAttribute(MalumAttributes.MALIGNANT_AEGIS_CAPACITY);
        if ((double)this.getMalignantAegis() < capacity.getValue()) {
            Player player;
            Double multiplier = Optional.ofNullable(entity.getAttribute(MalumAttributes.MALIGNANT_AEGIS_RECOVERY_GAIN)).map(AttributeInstance::getValue).orElse(1.0);
            int previousAegis = this.malignantAegis;
            this.addAegis(Mth.ceil((double)(amount * multiplier)));
            if (!(this.malignantAegis <= previousAegis || entity instanceof Player && (player = (Player)entity).isCreative())) {
                DeferredHolder<SoundEvent, SoundEvent> sound = (double)this.malignantAegis >= capacity.getValue() ? MalumSoundEvents.MALIGNANT_AEGIS_FULLY_CHARGED : MalumSoundEvents.MALIGNANT_AEGIS_GROW;
                double pitchOffset = (double)this.malignantAegis / capacity.getValue() * 0.5;
                SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)sound.get()), (float)0.75f, (float)((float)(1.0 + pitchOffset)));
            }
        }
        this.addCooldown(entity, 1.0f);
    }

    public void addAegis(int added) {
        this.setAegis(this.malignantAegis + added);
    }

    public void reduceAegis(int removed) {
        this.setAegis(this.malignantAegis - removed);
    }

    public void setAegis(int malignantAegis) {
        this.malignantAegis = Math.max(malignantAegis, 0);
        this.isDirty = true;
    }

    public void addCooldown(LivingEntity entity, float multiplier) {
        double newCooldown = this.getMalignantAegisCooldown(entity) * multiplier;
        if ((double)this.aegisCooldown < newCooldown) {
            this.aegisCooldown = Mth.floor((double)newCooldown);
            this.isDirty = true;
        }
    }

    public void cacheValue(AttributeInstance attribute) {
        this.cachedAttributeValues.put((Holder<Attribute>)attribute.getAttribute(), attribute.getValue());
    }

    public boolean hasCachedValue(Holder<Attribute> attribute) {
        return this.cachedAttributeValues.containsKey(attribute);
    }

    public double getCachedValue(Holder<Attribute> attribute) {
        return this.cachedAttributeValues.getOrDefault(attribute, 0.0);
    }

    public int getMalignantAegis() {
        return this.malignantAegis;
    }

    public static Optional<MalignantInfluenceData> getMalignantAegisData(LivingEntity entity) {
        if (MalignantInfluenceData.getMalignantAegisCapacity(entity) <= 0) {
            return Optional.empty();
        }
        return Optional.of((MalignantInfluenceData)entity.getData(MalumAttachmentTypes.MALIGNANT_INFLUENCE));
    }

    public static int getMalignantAegisCapacity(LivingEntity entity) {
        double aegis = entity.getAttributeValue(MalumAttributes.MALIGNANT_AEGIS_CAPACITY);
        return Mth.ceil((double)aegis);
    }

    public float getMalignantAegisCooldown(LivingEntity entity) {
        double recoveryRate = entity.getAttributeValue(MalumAttributes.MALIGNANT_AEGIS_RECOVERY_RATE);
        Integer cooldownDuration = (Integer)CommonConfig.MALIGNANT_AEGIS_RATE.getConfigValue();
        return Mth.floor((double)((double)cooldownDuration.intValue() / recoveryRate));
    }
}

