/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlock;
import com.sammy.malum.core.handlers.WindTunnelHandler;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.visual_effects.networked.wind_gust.WindTrailParticleEffect;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindTunnelData {
    public static Codec<WindTunnelData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)WindTunnelMotionData.CODEC.listOf().optionalFieldOf("strength", Collections.emptyList()).forGetter(WindTunnelData::getInfluence), (App)Codec.INT.optionalFieldOf("activeTime", (Object)0).forGetter(WindTunnelData::getActiveTime)).apply((Applicative)obj, WindTunnelData::new));
    public static StreamCodec<ByteBuf, WindTunnelData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private final HashMap<BlockPos, WindTunnelMotionData> influence = new HashMap();
    private int activeTime;

    private WindTunnelData(List<WindTunnelMotionData> influence, int activeTime) {
        for (WindTunnelMotionData data : influence) {
            this.influence.put(data.source, data);
        }
        this.activeTime = activeTime;
    }

    public WindTunnelData() {
    }

    public void tickData(Entity entity) {
        Level level = entity.level();
        Vec3 position = entity.position();
        Collection<WindTunnelMotionData> values = this.influence.values();
        ArrayList<WindTunnelMotionData> toRemove = new ArrayList<WindTunnelMotionData>(values);
        for (WindTunnelMotionData data : values) {
            BlockEntity blockEntity;
            Player player;
            BlockPos source = data.source;
            AABB area = data.area;
            Direction direction = data.direction;
            if (source == null || area == null || direction == null || entity instanceof Player && (player = (Player)entity).onGround() && player.isCrouching() || !((blockEntity = level.getBlockEntity(source)) instanceof GustIgniterBlockEntity)) continue;
            GustIgniterBlockEntity igniter = (GustIgniterBlockEntity)blockEntity;
            if (!WindTunnelBlock.isActive(level.getBlockState(source)) || !area.intersects(entity.getBoundingBox()) || !WindTunnelHandler.isInArea(entity, area, direction, igniter.windTunnels)) continue;
            float x = direction.getStepX();
            float y = direction.getStepY();
            float z = direction.getStepZ();
            Direction.Axis axis = direction.getAxis();
            boolean isX = axis.equals((Object)Direction.Axis.X);
            boolean isY = axis.equals((Object)Direction.Axis.Y);
            boolean isZ = axis.equals((Object)Direction.Axis.Z);
            float xFriction = isX ? 0.8f : 1.0f;
            float yFriction = isY ? 0.8f : 0.5f;
            float zFriction = isZ ? 0.8f : 1.0f;
            Vec3 addedVelocity = new Vec3((double)x, (double)y, (double)z).scale((double)data.strength);
            Vec3 movement = entity.getDeltaMovement();
            movement = movement.add(addedVelocity);
            if (axis.isHorizontal()) {
                Vec3 center = area.getCenter();
                center = new Vec3(isX ? position.x : center.x, (isY ? position.y : center.y) - (double)(entity.getBbHeight() / 2.0f), isZ ? position.z : center.z);
                Vec3 toCenter = center.subtract(position);
                Vec3 centerVelocity = toCenter.normalize().scale(toCenter.length() * (double)0.2f * (double)data.strength);
                movement = movement.add(centerVelocity);
            }
            movement = movement.multiply((double)xFriction, (double)yFriction, (double)zFriction);
            entity.setDeltaMovement(movement);
            toRemove.remove(data);
        }
        values.removeAll(toRemove);
        if (this.influence.isEmpty()) {
            entity.removeData(MalumAttachmentTypes.WIND_TUNNEL_INFO);
            return;
        }
        if (level instanceof ServerLevel) {
            int interval;
            ServerLevel serverLevel = (ServerLevel)level;
            boolean isPlayer = entity instanceof Player;
            int n = interval = isPlayer ? 4 : 20;
            if (this.activeTime % interval == 0) {
                MalumParticleEffectTypes.WIND_TRAIL.createEffect(entity).customData(new WindTrailParticleEffect.WindTrailParticleEffectData(entity.getId(), 2, 4)).color(new Color(224, 230, 255)).spawn(serverLevel);
                entity.syncData(MalumAttachmentTypes.WIND_TUNNEL_INFO);
            }
            if (!isPlayer) {
                entity.hurtMarked = true;
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.resetFallDistance();
        }
        ++this.activeTime;
    }

    public boolean addInfluence(GustIgniterBlockEntity igniter) {
        BlockPos pos = igniter.getBlockPos();
        float strength = igniter.getTunnelStrength();
        if (this.influence.containsKey(pos) && this.influence.get((Object)pos).strength == strength) {
            return false;
        }
        AABB area = igniter.windArea;
        Direction direction = igniter.windDirection;
        if (igniter.modified) {
            direction = direction.getOpposite();
        }
        this.influence.put(pos, new WindTunnelMotionData(pos, area, direction, strength));
        return true;
    }

    public float getGravityMultiplier() {
        return 1.0f - (float)Math.min(this.activeTime, 4) / 4.0f;
    }

    public List<WindTunnelMotionData> getInfluence() {
        return new ArrayList<WindTunnelMotionData>(this.influence.values());
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    public record WindTunnelMotionData(BlockPos source, AABB area, Direction direction, float strength) {
        public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min_x").forGetter(aabb -> aabb.minX), (App)Codec.DOUBLE.fieldOf("min_y").forGetter(aabb -> aabb.minY), (App)Codec.DOUBLE.fieldOf("min_z").forGetter(aabb -> aabb.minZ), (App)Codec.DOUBLE.fieldOf("max_x").forGetter(aabb -> aabb.maxX), (App)Codec.DOUBLE.fieldOf("max_y").forGetter(aabb -> aabb.maxY), (App)Codec.DOUBLE.fieldOf("max_z").forGetter(aabb -> aabb.maxZ)).apply((Applicative)instance, AABB::new));
        public static final Codec<WindTunnelMotionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("source").forGetter(WindTunnelMotionData::source), (App)AABB_CODEC.fieldOf("area").forGetter(WindTunnelMotionData::area), (App)Direction.CODEC.fieldOf("direction").forGetter(WindTunnelMotionData::direction), (App)Codec.FLOAT.fieldOf("strength").forGetter(WindTunnelMotionData::strength)).apply((Applicative)instance, WindTunnelMotionData::new));
    }
}

