/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record SpiritJarContentsComponent(SpiritArcanaType spirit, int count) implements SpiritLike
{
    public static Codec<SpiritJarContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpiritArcanaType.CODEC.fieldOf("spirit").forGetter(SpiritJarContentsComponent::spirit), (App)Codec.INT.fieldOf("count").forGetter(SpiritJarContentsComponent::count)).apply((Applicative)instance, SpiritJarContentsComponent::new));
    public static StreamCodec<ByteBuf, SpiritJarContentsComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public SpiritJarContentsComponent(SpiritLike spirit, int count) {
        this(spirit.getSpirit(), count);
    }

    public ItemStack createStack() {
        return this.createStack(Math.min(this.count, 64));
    }

    public ItemStack createStack(int count) {
        return this.spirit.getSpiritStack(count);
    }

    public SpiritJarContentsComponent add(int added) {
        return new SpiritJarContentsComponent(this.spirit, this.count + added);
    }

    public SpiritJarContentsComponent remove(int removed) {
        int amount = Math.max(this.count - removed, 0);
        if (amount == 0) {
            return null;
        }
        return new SpiritJarContentsComponent(this.spirit, amount);
    }

    @Override
    @NotNull
    public SpiritArcanaType getSpirit() {
        return this.spirit;
    }
}

