/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.mojang.logging.LogUtils;
import com.sammy.malum.registry.common.entity.MalumEntities;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class AscendingBlockEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockState blockState = Blocks.SAND.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float maxRiseTicks;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(AscendingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public AscendingBlockEntity(Level level) {
        super((EntityType)MalumEntities.ASCENDING_BLOCK.get(), level);
    }

    private AscendingBlockEntity(Level level, double x, double y, double z, BlockState state, float lifetime) {
        this(level);
        this.maxRiseTicks = lifetime;
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public static AscendingBlockEntity rise(Level level, BlockPos pos, BlockState blockState, float lifetime) {
        AscendingBlockEntity fallingblockentity = new AscendingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : blockState, lifetime);
        level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)fallingblockentity);
        return fallingblockentity;
    }

    public boolean isAttackable() {
        return false;
    }

    public void setStartPos(BlockPos startPos) {
        this.entityData.set(DATA_START_POS, (Object)startPos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.entityData.get(DATA_START_POS);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_START_POS, (Object)BlockPos.ZERO);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return -0.02;
    }

    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
        } else {
            if (!this.level().isClientSide()) {
                ((ServerLevel)this.level()).getChunkSource().broadcast((Entity)this, (Packet)new ClientboundSetEntityMotionPacket((Entity)this));
                ((ServerLevel)this.level()).getChunkSource().broadcast((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
            }
            ++this.time;
            this.applyGravity();
            double grav = this.getDefaultGravity();
            if (grav != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -grav, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.handlePortal();
            BlockPos posAbove = this.blockPosition().above();
            if (!this.level().getBlockState(posAbove).isAir()) {
                this.placeBlockAndDiscard(this.blockPosition());
                return;
            }
            if ((float)this.time >= this.maxRiseTicks) {
                this.placeBlockAndDiscard(this.blockPosition());
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    private void placeBlockAndDiscard(BlockPos pos) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.setBlock(pos, this.getBlockState(), 3)) {
            this.spawnAtLocation((ItemLike)this.getBlockState().getBlock());
        }
        this.discard();
        serverLevel.gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, pos);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        DamageSource var10000;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.ceil((float)(fallDistance - 1.0f));
        if (i < 0) {
            return false;
        }
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block var8 = this.blockState.getBlock();
        if (var8 instanceof Fallable) {
            Fallable fallable = (Fallable)var8;
            var10000 = fallable.getFallDamageSource((Entity)this);
        } else {
            var10000 = this.damageSources().fallingBlock((Entity)this);
        }
        DamageSource damagesource = var10000;
        float f = Math.min(Mth.floor((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.level().getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(p_149649_ -> p_149649_.hurt(damagesource, f));
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        if (flag && f > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.damage((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        compound.putInt("Time", this.time);
        compound.putBoolean("DropItem", this.dropItem);
        compound.putBoolean("HurtEntities", this.hurtEntities);
        compound.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        compound.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            compound.put("TileEntityData", (Tag)this.blockData);
        }
        compound.putBoolean("CancelDrop", this.cancelDrop);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("BlockState"));
        this.time = compound.getInt("Time");
        if (compound.contains("HurtEntities", 99)) {
            this.hurtEntities = compound.getBoolean("HurtEntities");
            this.fallDamagePerDistance = compound.getFloat("FallHurtAmount");
            this.fallDamageMax = compound.getInt("FallHurtMax");
        } else if (this.blockState.is(BlockTags.ANVIL)) {
            this.hurtEntities = true;
        }
        if (compound.contains("DropItem", 99)) {
            this.dropItem = compound.getBoolean("DropItem");
        }
        if (compound.contains("TileEntityData", 10)) {
            this.blockData = compound.getCompound("TileEntityData").copy();
        }
        this.cancelDrop = compound.getBoolean("CancelDrop");
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        super.fillCrashReportCategory(category);
        category.setDetail("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    protected Component getTypeName() {
        return Component.translatable((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.getBlock().getName()});
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.blockState = Block.stateById((int)packet.getData());
        this.blocksBuilding = true;
        double d0 = packet.getX();
        double d1 = packet.getY();
        double d2 = packet.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    public boolean isNoGravity() {
        return true;
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        ResourceKey resourcekey = transition.newLevel().dimension();
        ResourceKey resourcekey1 = this.level().dimension();
        boolean flag = (resourcekey1 == Level.END || resourcekey == Level.END) && resourcekey1 != resourcekey;
        Entity entity = super.changeDimension(transition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }
}

