/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.arcane;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class ReciprocationGeas
extends GeasEffect {
    public ReciprocationGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_RECIPROCATION.get());
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (event.getSource().is(LodestoneDamageTypeTags.IS_MAGIC)) {
                SoulWardData data = (SoulWardData)player.getData(MalumAttachmentTypes.SOUL_WARD);
                double attackSpeed = Math.max(attacker.getAttributeValue(Attributes.ATTACK_SPEED), (double)0.01f);
                data.recoverSoulWard((LivingEntity)player, 0.25 / attackSpeed);
            }
        }
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("soul_ward_on_hit", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, 12.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_GAIN, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }
}

