/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment.core;

import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.block.the_device.TheDevice;
import com.sammy.malum.common.item.augment.core.CoreAugmentItem;
import com.sammy.malum.common.worldevent.SuspiciousDeviceTriggerWorldEvent;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SuspiciousDeviceItem
extends CoreAugmentItem {
    public SuspiciousDeviceItem(Item.Properties pProperties) {
        super(pProperties, List.of(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT), true, new ArtificeModifier(ArtificeAttributeType.INSTABILITY, 1.0f));
    }

    public static void blowUp(ServerLevel level, BlockPos pos) {
        int delay = 20;
        float pitch = RandomHelper.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
        SoundEvent sound = (SoundEvent)MalumSoundEvents.SUSPICIOUS_DEVICE_DETONATES.get();
        if (level.getBlockState(pos.below()).getBlock() instanceof TheDevice) {
            delay = 50;
            pitch = 1.0f;
            sound = (SoundEvent)MalumSoundEvents.SWAG_MESSIAH.get();
        }
        WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)new SuspiciousDeviceTriggerWorldEvent().setPosition(pos).setData(List.of(1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8), 1, delay));
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 2.5f, pitch);
        MalumParticleEffectTypes.SUSPICIOUS_DEVICE_PRIMER.createEffect().at(pos.getCenter().add(SpiritCrucibleCoreBlockEntity.CRUCIBLE_CORE_AUGMENT_OFFSET)).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT).spawn(level);
    }
}

