/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.alchemical;

import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.compat.irons_spellbooks.IronsSpellsCompat;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class CurioManaweavingRing
extends MalumCurioItem
implements IMalumEventResponder {
    public CurioManaweavingRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ALCHEMICAL);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("spirits_weave_mana", new Object[0]));
        if (IronsSpellsCompat.LOADED) {
            consumer.accept(ComponentHelper.positiveCurioEffect("spirits_weave_mana_irons_spellbooks", new Object[0]));
        }
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        if (collector instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)collector;
            SoulWardData data = (SoulWardData)player.getData(MalumAttachmentTypes.SOUL_WARD);
            data.recoverSoulWard((LivingEntity)player, arcaneResonance);
            IronsSpellsCompat.generateMana(player, 10.0 * arcaneResonance);
        }
    }
}

