/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioGruesomeConcentrationRing
extends MalumCurioItem
implements IVoidItem {
    public CurioGruesomeConcentrationRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("rotten_gluttony", new Object[0]));
    }

    public static void onEat(Level level, LivingEntity livingEntity, ItemStack food) {
        if (level.isClientSide) {
            return;
        }
        if (food.is(MalumTags.ItemTags.GROSS_FOODS) && CurioHelper.hasCurioEquipped((LivingEntity)livingEntity, (Item)((Item)MalumItems.RING_OF_GRUESOME_CONCENTRATION.get()))) {
            GluttonyEffect.applyGluttony(livingEntity, b -> b.setInitialDuration(600).setInitialAmplifier(1).setAmplifierGain(2).setAmplifierLimit(10));
            livingEntity.playSound((SoundEvent)MalumSoundEvents.GRUESOME_RING_FEEDS.get(), 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f));
        }
    }
}

