/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.handlers.enchantment.ReplenishingHandler;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneCombatItem;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;

public abstract class AbstractStaffItem
extends LodestoneCombatItem
implements IMalumEventResponder {
    public AbstractStaffItem(Tier tier, float magicDamage, float chargeRate, int chargeCapacity, LodestoneItemProperties properties) {
        this(tier, 1.0f, -3.0f, magicDamage, chargeRate, chargeCapacity, properties);
    }

    public AbstractStaffItem(Tier tier, float attackDamage, float attackSpeed, float magicDamage, float chargeRate, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, properties.mergeAttributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add((Holder)LodestoneAttributes.MAGIC_DAMAGE, new AttributeModifier(LodestoneAttributes.BASE_MAGIC_DAMAGE, (double)magicDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(MalumAttributes.CHARGE_CAPACITY, new AttributeModifier(MalumAttributes.BASE_CHARGE_CAPACITY, (double)chargeCapacity, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(MalumAttributes.CHARGE_DURATION, new AttributeModifier(MalumAttributes.BASE_CHARGE_DURATION, (double)chargeRate, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnChargeParticles(Level var1, LivingEntity var2, Vec3 var3, ItemStack var4, float var5);

    public abstract int getProjectileCount(Level var1, LivingEntity var2, float var3);

    public abstract void fireProjectile(LivingEntity var1, ItemStack var2, Level var3, InteractionHand var4, int var5);

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (event.getSource().is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                ServerLevel level = player.serverLevel();
                SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.STAFF_STRIKES.get()), (SoundSource)attacker.getSoundSource(), (float)2.0f, (float)RandomHelper.randomBetween((RandomSource)level.random, (float)0.85f, (float)1.25f));
                MalumParticleEffectTypes.STAFF_SLAM.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).color(stack.getItem()).forwardOffset(1.4f).upwardOffset(0.3f).spawn(level);
                if (EnchantmentKeys.getEnchantmentLevel((Level)level, EnchantmentKeys.REPLENISHING, stack) > 0) {
                    ReplenishingHandler.triggerReplenishing(event.getSource(), attacker, stack);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        StaffAbilityData data;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        float duration = (float)pPlayer.getAttributes().getValue(MalumAttributes.CHARGE_DURATION) * 20.0f;
        if (!pPlayer.getAbilities().instabuild && !(data = (StaffAbilityData)pPlayer.getData(MalumAttachmentTypes.STAFF_ABILITIES)).canUseStaff((LivingEntity)pPlayer)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (duration <= 0.0f) {
                this.shoot(itemstack, serverLevel, (LivingEntity)pPlayer, this.getProjectileCount(pLevel, (LivingEntity)pPlayer, 1.0f));
            }
        }
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        int useDuration = this.getUseDuration(pStack, pLivingEntity);
        float duration = (float)pLivingEntity.getAttributes().getValue(MalumAttributes.CHARGE_DURATION) * 20.0f;
        if (duration <= 0.0f) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        float delta = Math.min(duration, (float)(useDuration - pRemainingUseDuration)) / duration;
        InteractionHand hand = pLivingEntity.getUsedItemHand();
        if (pLevel.isClientSide) {
            Vec3 pos = this.getProjectileSpawnPos(pLivingEntity, hand, 1.5f, 0.6f);
            this.spawnChargeParticles(pLevel, pLivingEntity, pos, pStack, delta);
            return;
        }
        int fullyCharged = useDuration - Mth.ceil((float)duration);
        if (pRemainingUseDuration == fullyCharged) {
            float pitch = Mth.nextFloat((RandomSource)pLevel.random, (float)1.6f, (float)1.8f);
            pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)MalumSoundEvents.STAFF_CHARGED.get(), SoundSource.PLAYERS, 1.25f, pitch);
            if (GeasEffectHandler.hasGeasEffect(pLivingEntity, MalumGeasEffectTypes.OATH_OF_THE_OVEREAGER_FIST)) {
                if (pLivingEntity instanceof Player) {
                    Player player = (Player)pLivingEntity;
                    player.getCooldowns().addCooldown((Item)this, 5);
                }
                pLivingEntity.releaseUsingItem();
            }
            return;
        }
        if (pRemainingUseDuration > fullyCharged && pRemainingUseDuration % 5 == 0) {
            float pitch = delta + Mth.nextFloat((RandomSource)pLevel.random, (float)0.6f, (float)0.7f);
            pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)MalumSoundEvents.STAFF_POWERS_UP.get(), SoundSource.PLAYERS, 0.75f, pitch);
            return;
        }
        if (pRemainingUseDuration % 5 == 0) {
            float pitch = Mth.nextFloat((RandomSource)pLevel.random, (float)0.3f, (float)0.4f);
            pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)MalumSoundEvents.STAFF_POWERS_UP.get(), SoundSource.PLAYERS, 0.5f, pitch);
        }
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        float duration = (float)pLivingEntity.getAttributes().getValue(MalumAttributes.CHARGE_DURATION) * 20.0f;
        float delta = Math.min(duration, (float)(this.getUseDuration(pStack, pLivingEntity) - pTimeCharged)) / duration;
        int projectileCount = this.getProjectileCount(pLevel, pLivingEntity, delta);
        if (projectileCount > 0) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                this.shoot(pStack, serverLevel, pLivingEntity, projectileCount);
            }
            return;
        }
        float pitch = Mth.nextFloat((RandomSource)pLevel.random, (float)0.5f, (float)0.8f);
        pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)MalumSoundEvents.STAFF_SIZZLES_OUT.get(), SoundSource.PLAYERS, 0.5f, pitch);
    }

    public void shoot(ItemStack stack, ServerLevel level, LivingEntity entity, int projectileCount) {
        InteractionHand hand = entity.getUsedItemHand();
        float magicDamage = (float)entity.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        if (magicDamage == 0.0f) {
            float pitch = Mth.nextFloat((RandomSource)level.random, (float)0.5f, (float)0.8f);
            level.playSound(null, entity.blockPosition(), (SoundEvent)MalumSoundEvents.STAFF_SIZZLES_OUT.get(), SoundSource.PLAYERS, 0.5f, pitch);
            entity.swing(hand, true);
            return;
        }
        for (int i = 0; i < projectileCount; ++i) {
            this.fireProjectile(entity, stack, (Level)level, hand, i);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
                StaffAbilityData data = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES);
                data.consumeStaffCharge((LivingEntity)player);
            }
            player.swing(hand, true);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public Vec3 getProjectileSpawnPos(LivingEntity player, InteractionHand hand, float distance, float spread) {
        int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
        double radians = Math.toRadians((float)angle - player.yHeadRot);
        return player.position().add(player.getLookAngle().scale((double)distance)).add((double)spread * Math.sin(radians), (double)(player.getBbHeight() * 0.9f), (double)spread * Math.cos(radians));
    }
}

