/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.spirit_repair;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpiritRepairRegexData {
    public static final Codec<SpiritRepairRegexData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("modIdRegex", (Object)"").forGetter(SpiritRepairRegexData::modIdRegex), (App)Codec.STRING.fieldOf("itemIdRegex").forGetter(SpiritRepairRegexData::itemIdRegex), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tagRegex").forGetter(t -> Optional.ofNullable(t.tagRegex))).apply((Applicative)instance, (modIdRegex, itemIdRegex, tagRegex) -> new SpiritRepairRegexData((String)modIdRegex, (String)itemIdRegex, (TagKey<Item>)((TagKey)tagRegex.orElse(null)))));
    public static final SpiritRepairRegexData EMPTY = new SpiritRepairRegexData("", "", null);
    private String modIdRegex;
    private String itemIdRegex;
    private TagKey<Item> tagRegex;

    public SpiritRepairRegexData(String modIdRegex, String itemIdRegex, TagKey<Item> tagRegex) {
        this.modIdRegex = modIdRegex;
        this.itemIdRegex = itemIdRegex;
        this.tagRegex = tagRegex;
    }

    public SpiritRepairRegexData withMod(String modIdRegex) {
        this.modIdRegex = modIdRegex;
        return this;
    }

    public SpiritRepairRegexData withItemId(String itemIdRegex) {
        this.itemIdRegex = itemIdRegex;
        return this;
    }

    public SpiritRepairRegexData withTag(TagKey<Item> tagRegex) {
        this.tagRegex = tagRegex;
        return this;
    }

    public static SpiritRepairRegexData tag(String tag) {
        return new SpiritRepairRegexData("", "", (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    public static SpiritRepairRegexData simple(String itemIdRegex) {
        return new SpiritRepairRegexData("", itemIdRegex, null);
    }

    public boolean isEmpty() {
        return this.itemIdRegex.isEmpty() && this.modIdRegex.isEmpty();
    }

    public String toString() {
        return "SpiritRepairRegexData{itemIdRegex='" + this.itemIdRegex + "', modIdRegex='" + this.modIdRegex + "'}";
    }

    public List<Holder<Item>> modifyRepairInput(List<Holder<Item>> repairInput) {
        ArrayList<Item> extraItems = new ArrayList<Item>(repairInput.stream().map(Holder::value).toList());
        for (int i = 0; i < BuiltInRegistries.ITEM.size(); ++i) {
            ResourceLocation id;
            ItemStack stack;
            Item item = (Item)BuiltInRegistries.ITEM.byId(i);
            if (!item.isRepairable(stack = item.getDefaultInstance()) || !(id = BuiltInRegistries.ITEM.getKey((Object)item)).getPath().matches(this.itemIdRegex) || !this.modIdRegex.isEmpty() && id.getNamespace().matches(this.modIdRegex) || extraItems.contains(item)) continue;
            extraItems.add(item);
        }
        return ImmutableList.copyOf(extraItems.stream().map(Item::builtInRegistryHolder).toList());
    }

    public String modIdRegex() {
        return this.modIdRegex;
    }

    public String itemIdRegex() {
        return this.itemIdRegex;
    }

    public TagKey<Item> tagRegex() {
        return this.tagRegex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpiritRepairRegexData that = (SpiritRepairRegexData)obj;
        return Objects.equals(this.modIdRegex, that.modIdRegex) && Objects.equals(this.itemIdRegex, that.itemIdRegex) && Objects.equals(this.tagRegex, that.tagRegex);
    }

    public int hashCode() {
        return Objects.hash(this.modIdRegex, this.itemIdRegex, this.tagRegex);
    }
}

