/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.serialization.Codec;
import com.sammy.malum.common.data.attachment.CachedSpiritDropsData;
import com.sammy.malum.common.data.attachment.ProgressionData;
import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.common.entity.spirit.SpiritItemEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.listeners.ReapingDataReloadListener;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.core.systems.events.ModifySpiritSpoilsEvent;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.RandomHelper;

public class SoulHarvestHandler {
    public static final Codec<SoulHarvestHandler> CODEC = Codec.unit(SoulHarvestHandler::new);

    public static void onDeath(LivingDeathEvent event) {
        LivingEntity living;
        LivingEntity attacker;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target instanceof Player) {
            return;
        }
        LivingSoulData data = (LivingSoulData)target.getData(MalumAttachmentTypes.LIVING_SOUL_INFO);
        if (data.isSoulless() || ((Boolean)CommonConfig.SOULLESS_SPAWNERS.getConfigValue()).booleanValue() && data.isSpawnerSpawned()) {
            return;
        }
        DamageSource source = event.getSource();
        Level level = target.level();
        Entity entity = source.getEntity();
        LivingEntity livingEntity = attacker = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : target.getLastHurtByMob();
        if (data.shouldDropSpirits()) {
            SoulHarvestHandler.dropSpiritInfusedDrops(target);
            SoulHarvestHandler.dropEncyclopediaArcana(target, attacker);
            SoulHarvestHandler.dropSpirits(target, attacker);
            if (attacker != null) {
                ((LivingSoulData)attacker.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).setMostRecentShatter(level.getGameTime());
            }
            data.setSoulless(true);
        }
    }

    public static void dropSpiritInfusedDrops(LivingEntity target) {
        List<ReapingDataReloadListener.MalumReapingDropsData> data = ReapingDataReloadListener.REAPING_DATA.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()));
        if (data != null) {
            for (ReapingDataReloadListener.MalumReapingDropsData dropData : data) {
                Level level = target.level();
                RandomSource random = level.random;
                if (!(random.nextFloat() < dropData.chance)) continue;
                ItemStack[] possibleDrops = dropData.drop.getItems();
                ItemStack stack = ItemHelper.copyWithNewCount((ItemStack)possibleDrops[random.nextInt(possibleDrops.length)], (int)Mth.nextInt((RandomSource)random, (int)dropData.min, (int)dropData.max));
                ItemEntity itemEntity = new ItemEntity(level, target.getX(), target.getY(), target.getZ(), stack);
                itemEntity.setDefaultPickUpDelay();
                itemEntity.setDeltaMovement((double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)0.25f, (float)0.5f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f));
                level.addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static void dropEncyclopediaArcana(LivingEntity target, LivingEntity attacker) {
        if (!((Boolean)CommonConfig.AWARD_CODEX_ON_KILL.getConfigValue()).booleanValue()) {
            return;
        }
        if (target.getType().is(EntityTypeTags.UNDEAD) && attacker instanceof Player) {
            Player player = (Player)attacker;
            ProgressionData data = (ProgressionData)player.getData(MalumAttachmentTypes.PROGRESSION_DATA);
            if (data.obtainedEncyclopedia) {
                return;
            }
            data.obtainedEncyclopedia = true;
            SoulHarvestHandler.spawnSpirits((Entity)target).setCustomItems((Item)MalumItems.ENCYCLOPEDIA_ARCANA.get()).setPreferredCollector(attacker).spawnSpirits(attacker.level());
        }
    }

    public static void dropSpirits(LivingEntity target, LivingEntity attacker) {
        Level level = target.level();
        SpiritSpawner spiritSpawner = SoulHarvestHandler.spawnSpirits((Entity)target).setPreferredCollector(attacker);
        Ingredient itemAsSoul = EntitySpiritDropData.getSpiritData(target).map(EntitySpiritDropData::getItemAsSoul).orElse(null);
        if (itemAsSoul != null) {
            UUID uuid = attacker != null ? attacker.getUUID() : null;
            target.setData(MalumAttachmentTypes.CACHED_SPIRIT_DROPS, (Object)new CachedSpiritDropsData(spiritSpawner.getSpiritDrops(), uuid));
            return;
        }
        spiritSpawner.spawnSpirits(level);
    }

    public static SpiritSpawner spawnSpirits(Entity target) {
        return new SpiritSpawner(target);
    }

    public static List<ItemStack> applySpiritLootBonuses(EntitySpiritDropData data, LivingEntity target, LivingEntity attacker) {
        ArrayList<ItemStack> spirits = new ArrayList<ItemStack>(data.getSpiritStacks());
        if (spirits.isEmpty()) {
            return spirits;
        }
        RandomSource random = attacker.getRandom();
        int bonus = Mth.floor((double)attacker.getAttributeValue(MalumAttributes.SPIRIT_SPOILS));
        ModifySpiritSpoilsEvent event = new ModifySpiritSpoilsEvent(target, attacker, bonus);
        ItemEventHandler.getEventResponders((LivingEntity)attacker).forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.modifySpiritSpoilsEvent(event, attacker)));
        NeoForge.EVENT_BUS.post((Event)event);
        bonus = event.getNewSpiritBonus();
        for (int i = 0; i < bonus; ++i) {
            int index = random.nextInt(spirits.size());
            ((ItemStack)spirits.get(index)).grow(1);
        }
        return spirits;
    }

    public static void pickupSpirit(LivingEntity collector, ItemStack stack) {
        SoulHarvestHandler.triggerSpiritCollection(collector);
        ItemEntity entity = new ItemEntity(collector.level(), collector.getX(), collector.getY() + 0.5, collector.getZ(), stack);
        entity.setPickUpDelay(0);
        if (collector instanceof Player) {
            Player player = (Player)collector;
            TriState result = EventHooks.fireItemPickupPre((ItemEntity)entity, (Player)player).canPickup();
            if (result.isFalse()) {
                return;
            }
            player.addItem(stack);
            player.onItemPickup(entity);
            if (!stack.isEmpty()) {
                ItemHelper.spawnItemOnEntity((LivingEntity)collector, (ItemStack)stack);
            }
        } else {
            collector.level().addFreshEntity((Entity)entity);
        }
    }

    public static void triggerSpiritCollection(LivingEntity collector) {
        CollectSpiritEvent collectionEvent = new CollectSpiritEvent(collector);
        double resonance = collector.getAttributeValue(MalumAttributes.ARCANE_RESONANCE);
        ItemEventHandler.getEventResponders((LivingEntity)collector).forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.spiritCollectionEvent(collectionEvent, collector, resonance)));
        NeoForge.EVENT_BUS.post((Event)collectionEvent);
    }

    public static class SpiritSpawner {
        private final Entity target;
        @Nullable
        private LivingEntity preferredCollector;
        private List<ItemStack> customItems = Collections.emptyList();

        public SpiritSpawner(Entity target) {
            this.target = target;
        }

        public SpiritSpawner setPreferredCollector(@Nullable LivingEntity preferredCollector) {
            this.preferredCollector = preferredCollector;
            return this;
        }

        public SpiritSpawner setCustomItems(Item ... customItems) {
            return this.setCustomItems(Arrays.stream(customItems).map(Item::getDefaultInstance).toList());
        }

        public SpiritSpawner setCustomItems(ItemStack ... customItems) {
            return this.setCustomItems(List.of(customItems));
        }

        public SpiritSpawner setCustomItems(List<ItemStack> customItems) {
            this.customItems = customItems;
            return this;
        }

        public Vec3 getSpawnPosition() {
            return this.target.position().add(0.0, (double)(this.target.getBbHeight() / 2.0f), 0.0);
        }

        public List<ItemStack> getSpiritDrops() {
            if (!this.customItems.isEmpty()) {
                return this.customItems;
            }
            Entity entity = this.target;
            if (!(entity instanceof LivingEntity)) {
                return Collections.emptyList();
            }
            LivingEntity living = (LivingEntity)entity;
            Optional<EntitySpiritDropData> optional = EntitySpiritDropData.getSpiritData(living);
            if (optional.isEmpty()) {
                return Collections.emptyList();
            }
            EntitySpiritDropData data = optional.get();
            if (this.preferredCollector == null) {
                return data.getSpiritStacks();
            }
            return SoulHarvestHandler.applySpiritLootBonuses(data, living, this.preferredCollector);
        }

        public void spawnSpirits(Level level) {
            Vec3 position = this.getSpawnPosition();
            List<ItemStack> spirits = this.getSpiritDrops();
            for (ItemStack spirit : spirits) {
                if (spirit.isEmpty()) continue;
                for (int j = 0; j < spirit.getCount(); ++j) {
                    ItemStack stack = spirit.copyWithCount(1);
                    Entity entity = this.createSpiritEntity(stack, position);
                    level.addFreshEntity(entity);
                }
            }
            float pitch = RandomHelper.randomBetween((RandomSource)level.random, (float)0.7f, (float)1.3f);
            level.playSound(null, position.x, position.y, position.z, MalumSoundEvents.SOUL_SHATTER, SoundSource.PLAYERS, 1.0f, pitch);
        }

        public Entity createSpiritEntity(ItemStack stack, Vec3 position) {
            Level level = this.target.level();
            RandomSource random = level.getRandom();
            float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.4f);
            float xSpeed = RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed);
            float ySpeed = RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f);
            float zSpeed = RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed);
            Vec3 velocity = new Vec3((double)xSpeed, (double)ySpeed, (double)zSpeed);
            if (((Boolean)CommonConfig.NO_FANCY_SPIRITS.getConfigValue()).booleanValue()) {
                ItemEntity itemEntity = new ItemEntity(level, position.x, position.y, position.z, stack);
                itemEntity.setDefaultPickUpDelay();
                itemEntity.setDeltaMovement((double)(xSpeed * 0.6f), (double)(ySpeed * 6.0f), (double)(zSpeed * 0.6f));
                return itemEntity;
            }
            return new SpiritItemEntity(level, this.preferredCollector, stack, position, velocity);
        }
    }
}

