/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.MalignantInfluenceData;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.client.MalumShaders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class MalignantAegisRenderHandler {
    public static ResourceLocation REINFORCEMENT = MalumMod.malumPath("textures/gui/hud/malignant_aegis.png");
    public static ResourceLocation GLOW = MalumMod.malumPath("textures/gui/hud/malignant_aegis_glow.png");
    public static ResourceLocation EMPTY = MalumMod.malumPath("textures/gui/hud/malignant_aegis_empty.png");
    public static ResourceLocation DISSOLVEMENT = MalumMod.malumPath("textures/gui/hud/malignant_aegis_dissolvement.png");
    public static int glow;
    public static int fadeout;
    public static float displayedReinforcement;

    public static void tick(ClientTickEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            MalignantInfluenceData.getMalignantAegisData((LivingEntity)player).ifPresent(data -> {
                double capacity = MalignantInfluenceData.getMalignantAegisCapacity((LivingEntity)player);
                double currentReinforcement = data.getMalignantAegis();
                if (currentReinforcement >= capacity) {
                    if (glow < 80) {
                        ++glow;
                    }
                } else if (glow > 0) {
                    --glow;
                }
                if ((double)displayedReinforcement - currentReinforcement > (double)0.01f) {
                    glow = 40;
                }
                displayedReinforcement = Mth.lerp((float)0.2f, (float)displayedReinforcement, (float)((float)currentReinforcement));
                if (currentReinforcement > 0.0 && currentReinforcement < capacity) {
                    if (fadeout > 0) {
                        fadeout = Math.max(0, fadeout - 10);
                    }
                } else if (fadeout < 80) {
                    ++fadeout;
                }
            });
        }
    }

    public static void renderMalignantAegis(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        if (!(minecraft.options.hideGui || (player = minecraft.player).isCreative() || player.isSpectator())) {
            double capacity = MalignantInfluenceData.getMalignantAegisCapacity((LivingEntity)player);
            if (displayedReinforcement > 0.0f && capacity > 0.0) {
                float delta = (float)((double)displayedReinforcement / capacity);
                float dissolvement = Easing.QUAD_OUT.ease(delta, 0.0f, 1.0f);
                float alpha = (1.0f - (float)fadeout / 80.0f) * 0.75f;
                int left = guiGraphics.guiWidth() / 2 - (Integer)ClientConfig.UI_SHIELD_X_OFFSET.getConfigValue();
                int top = guiGraphics.guiHeight() - (Integer)ClientConfig.UI_SHIELD_Y_OFFSET.getConfigValue();
                poseStack.pushPose();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ExtendedShaderInstance distorted = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
                distorted.safeGetUniform("YFrequency").set(24.0f);
                distorted.safeGetUniform("XFrequency").set(16.0f);
                distorted.safeGetUniform("Speed").set(1000.0f);
                distorted.safeGetUniform("Intensity").set(80.0f);
                distorted.safeGetUniform("Width").set(64.0f);
                distorted.safeGetUniform("Height").set(64.0f);
                VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setZLevel(100).setShader((ShaderInstance)distorted);
                builder.setPositionWithWidth((float)(left - 16), (float)(top - 16), 32.0f, 32.0f);
                builder.setAlpha(alpha).setTexture(EMPTY).blit(poseStack);
                ExtendedShaderInstance hud = MalumShaders.DISSOLVING_HUD_ELEMENT.getShaderInstance();
                RenderSystem.setShaderTexture((int)1, (ResourceLocation)DISSOLVEMENT);
                hud.safeGetUniform("YFrequency").set(24.0f);
                hud.safeGetUniform("XFrequency").set(16.0f);
                hud.safeGetUniform("Speed").set(1000.0f);
                hud.safeGetUniform("Intensity").set(80.0f);
                hud.safeGetUniform("Dissolvement").set(dissolvement);
                hud.safeGetUniform("Width").set(64.0f);
                hud.safeGetUniform("Height").set(64.0f);
                builder.setShader((ShaderInstance)hud).setTexture(REINFORCEMENT).blit(poseStack);
                RenderSystem.blendFunc((int)770, (int)1);
                builder.setAlpha(0.2f * alpha).blit(poseStack);
                if (glow > 0 && glow < 80) {
                    float time = (float)minecraft.level.getGameTime() + deltaTracker.getGameTimeDeltaPartialTick(true);
                    float glowAlpha = (float)(40 - Math.abs(40 - glow)) / 40.0f;
                    int angle = Mth.floor((float)(time * 20.0f % 360.0f));
                    float range = Easing.SINE_IN_OUT.ease(glowAlpha, 160.0f, 320.0f);
                    ExtendedShaderInstance light = LodestoneShaders.RADIAL_DISTORTED_SCREEN_LIGHT.getShaderInstance();
                    light.safeGetUniform("YFrequency").set(24.0f);
                    light.safeGetUniform("XFrequency").set(16.0f);
                    light.safeGetUniform("Speed").set(1000.0f);
                    light.safeGetUniform("Intensity").set(80.0f);
                    light.safeGetUniform("Width").set(64.0f);
                    light.safeGetUniform("Height").set(64.0f);
                    light.safeGetUniform("Angle").set(angle);
                    light.safeGetUniform("LightAngleRange").set(range);
                    RenderSystem.blendFunc((int)770, (int)1);
                    builder.setShader((ShaderInstance)light).setAlpha(alpha);
                    if ((double)displayedReinforcement >= capacity) {
                        builder.setTexture(REINFORCEMENT).blit(poseStack);
                    }
                    builder.setTexture(GLOW).blit(poseStack);
                    light.setUniformDefaults();
                }
                distorted.setUniformDefaults();
                hud.setUniformDefaults();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                poseStack.popPose();
            }
        }
    }
}

