/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.client;

import com.sammy.malum.client.screen.waveform.AbstractValueConfigurationScreen;
import com.sammy.malum.client.screen.waveform.DiodeValueConfigurationScreen;
import com.sammy.malum.client.screen.waveform.GustGizmoConfigurationScreen;
import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.redstone.OpenStateBlockEntity;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import com.sammy.malum.registry.common.MalumTags;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class WaveformConfigurationHandler {
    public static BlockPos interactionPos;
    public static InteractionHand interactionHand;
    public static int interactionTime;

    public static void tick(ClientTickEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (interactionPos == null) {
            return;
        }
        HitResult hitResult = minecraft.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            WaveformConfigurationHandler.resetInteraction();
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!blockPos.equals((Object)interactionPos)) {
            WaveformConfigurationHandler.resetInteraction();
            return;
        }
        BlockEntity blockEntity = minecraft.level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof OpenStateBlockEntity)) {
            WaveformConfigurationHandler.resetInteraction();
            return;
        }
        OpenStateBlockEntity entity = (OpenStateBlockEntity)blockEntity;
        if (!entity.canTinker()) {
            WaveformConfigurationHandler.resetInteraction();
            return;
        }
        if (!minecraft.options.keyUse.isDown()) {
            WaveformConfigurationHandler.resetInteraction();
            return;
        }
        if (++interactionTime == 5) {
            AbstractValueConfigurationScreen screen = null;
            if (entity instanceof AbstractGustGizmoBlockEntity) {
                AbstractGustGizmoBlockEntity gustGizmo = (AbstractGustGizmoBlockEntity)entity;
                OpenStateBlockEntity openStateBlockEntity = gustGizmo.getTinkeredBlock();
                if (openStateBlockEntity instanceof GustIgniterBlockEntity) {
                    GustIgniterBlockEntity igniter;
                    screen = new GustGizmoConfigurationScreen(igniter, (igniter = (GustIgniterBlockEntity)openStateBlockEntity) != gustGizmo);
                }
            } else if (entity instanceof SpiritDiodeBlockEntity) {
                SpiritDiodeBlockEntity spiritDiode = (SpiritDiodeBlockEntity)entity;
                screen = new DiodeValueConfigurationScreen(spiritDiode);
            }
            minecraft.setScreen(screen);
            WaveformConfigurationHandler.resetInteraction();
        }
    }

    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand hand;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = player.getItemInHand(hand = event.getHand());
        if (!stack.is(MalumTags.ItemTags.IS_REDSTONE_TOOL)) {
            return;
        }
        if (!WaveformConfigurationHandler.canInteract(player)) {
            return;
        }
        if (!(world.getBlockEntity(pos) instanceof OpenStateBlockEntity)) {
            return;
        }
        if (interactionPos != null) {
            event.setCanceled(true);
            return;
        }
        interactionPos = pos;
        interactionHand = hand;
        interactionTime = 0;
        player.swing(hand);
        event.setCanceled(true);
    }

    public static void resetInteraction() {
        interactionPos = null;
        interactionHand = null;
        interactionTime = 0;
    }

    public static boolean canInteract(Player player) {
        return player != null && !player.isSpectator() && !player.isShiftKeyDown() && player.mayBuild();
    }
}

