/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.data.attachment.WeepingWellData;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class ScreenParticleEffects {
    public static void spawnRuneParticles(ScreenParticleHolder target, SpiritLike spiritType) {
        RandomSource rand = Minecraft.getInstance().level.getRandom();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.SPARKLE, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f + rand.nextFloat() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)20, (int)30)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(2.0, -1.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.015f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)Mth.nextFloat((RandomSource)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.3f + rand.nextFloat() * 0.3f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData((ColorParticleDataWrapper)spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)20, (int)30)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(2.0, 0.0).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)8, (int)12)).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f + rand.nextFloat() * 0.3f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(2.0, -1.0);
    }

    public static void spawnSpiritShardScreenParticles(ScreenParticleHolder target, SpiritHolder<SpiritArcanaType> spiritType) {
        RandomSource rand = Minecraft.getInstance().level.getRandom();
        Color color = spiritType.getPrimaryColor();
        Color endColor = spiritType.getSecondaryColor();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.SPARKLE, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f + rand.nextFloat() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setLifetime(10 + rand.nextInt(10)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)Mth.nextFloat((RandomSource)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f + rand.nextFloat() * 0.4f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(1.25f).build()).setLifetime(20 + rand.nextInt(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnGeasItemScreenParticles(ScreenParticleHolder target, Level level, float partialTick) {
        if (level.getGameTime() % 4L == 0L) {
            float colorMultiplier = Mth.nextFloat((RandomSource)level.random, (float)0.4f, (float)1.2f);
            Color color = new Color((int)(31.0f * colorMultiplier), (int)(19.0f * colorMultiplier), (int)(31.0f * colorMultiplier));
            Color endColor = new Color((int)(111.0f * colorMultiplier), (int)(31.0f * colorMultiplier), (int)(121.0f * colorMultiplier));
            float gameTime = (float)level.getGameTime() + partialTick;
            RandomSource rand = Minecraft.getInstance().level.getRandom();
            SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.0f).setSpinOffset(0.0125f * gameTime % 6.28f).build();
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.6f + rand.nextFloat() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.02f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setRandomMotion((double)0.05f, (double)0.05f).setLifetime(30 + rand.nextInt(10)).setSpinData((SpinParticleDataWrapper)spinParticleData).setRandomOffset((double)0.05f).spawnOnStack(0.0, 0.0);
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f + rand.nextFloat() * 0.6f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.02f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setRandomMotion((double)0.4f, (double)0.4f).setLifetime(40 + rand.nextInt(8)).setSpinData((SpinParticleDataWrapper)spinParticleData).setRandomOffset((double)0.1f).spawnOnStack(0.0, 0.0).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f + rand.nextFloat() * 0.4f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).setLifetime(10 + rand.nextInt(5)).spawnOnStack(0.0, 0.0);
        }
    }

    public static void spawnVoidItemScreenParticles(ScreenParticleHolder target, Level level, float intensity, float partialTick) {
        float colorMultiplier = Mth.nextFloat((RandomSource)level.random, (float)0.4f, (float)1.2f);
        float timeMultiplier = Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.4f);
        Color color = new Color((int)(31.0f * colorMultiplier), (int)(19.0f * colorMultiplier), (int)(31.0f * colorMultiplier));
        Color endColor = new Color((int)(111.0f * colorMultiplier), (int)(31.0f * colorMultiplier), (int)(121.0f * colorMultiplier));
        float gameTime = (float)level.getGameTime() + partialTick;
        RandomSource rand = Minecraft.getInstance().level.getRandom();
        SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.0f, (float)(level.random.nextBoolean() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).setEasing(Easing.EXPO_IN_OUT).build();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.2f * intensity + rand.nextFloat() * 0.1f * intensity), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setSpinData((SpinParticleDataWrapper)spinParticleData).setLifetime((int)((float)(10 + rand.nextInt(10)) * timeMultiplier)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f * intensity + rand.nextFloat() * 0.6f * intensity), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData((SpinParticleDataWrapper)spinParticleData).setLifetime(20 + rand.nextInt(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0).setLifetime((int)((float)(10 + rand.nextInt(2)) * timeMultiplier)).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f + rand.nextFloat() * 0.4f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnEncyclopediaEsotericaScreenParticles(ScreenParticleHolder target, Level level, float partialTick) {
        RandomSource rand = level.getRandom();
        float distance = 7.5f;
        for (int i = 0; i < 2; ++i) {
            float time = (((float)level.getGameTime() + partialTick) * 0.05f + (float)i * 3.14f) % 6.28f;
            float scalar = 0.6f;
            if (time > 1.57f && time < 4.71f) {
                scalar *= Easing.QUAD_IN.ease(Math.abs(3.14f - time) / 1.57f, 0.0f, 1.0f, 1.0f);
            }
            double xOffset = Math.sin(time) * (double)distance;
            double yOffset = Math.cos(time) * (double)distance * 0.5;
            float colorMultiplier = Mth.nextFloat((RandomSource)level.random, (float)0.7f, (float)1.0f);
            Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
            Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
            float gameTime = (float)level.getGameTime() + partialTick;
            SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)(level.random.nextBoolean() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)(0.1f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData((SpinParticleDataWrapper)spinParticleData).setLifetime(60).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
        }
    }

    public static class VoidTransmutableParticleEffect
    implements IVoidItem {
        public static VoidTransmutableParticleEffect INSTANCE = new VoidTransmutableParticleEffect();
        private boolean isNearWell;
        private boolean isItemReal;

        @Override
        public float getVoidParticleIntensity() {
            return 1.2f;
        }

        @Override
        public void spawnEarlyParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
            LocalPlayer player = Minecraft.getInstance().player;
            this.isNearWell = ((WeepingWellData)player.getData(MalumAttachmentTypes.WEEPING_WELL_INFO)).isNearWeepingWell;
            if (!this.isNearWell) {
                return;
            }
            if (level.getGameTime() % 20L == 0L) {
                this.isItemReal = player.getInventory().contains(stack);
            }
            if (this.isItemReal) {
                IVoidItem.super.spawnEarlyParticles(target, level, partialTick, stack, x, y);
            }
        }

        public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
            if (!this.isNearWell || !this.isItemReal) {
                return;
            }
            RandomSource rand = level.getRandom();
            float distance = 7.5f;
            for (int i = 0; i < 2; ++i) {
                float time = ((i == 1 ? 3.14f : 0.0f) + ((float)level.getGameTime() + partialTick) * 0.1f) % 6.28f;
                float scalar = 0.6f;
                double xOffset = Math.sin(time) * (double)distance;
                double yOffset = Math.cos(time) * (double)distance;
                float colorMultiplier = Mth.nextFloat((RandomSource)level.random, (float)0.7f, (float)1.0f);
                Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
                Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
                float gameTime = (float)level.getGameTime() + partialTick;
                SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)(level.random.nextBoolean() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
                ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.WISP, (ScreenParticleHolder)target).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.1f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData((SpinParticleDataWrapper)spinParticleData).setLifetime(40).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
            }
        }
    }
}

