/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseDragged(ScreenEvent.MouseDragged.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent()) {
            manager.mouseDragged(event.getMouseX(), event.getMouseY(), event.getMouseButton());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseScolled(ScreenEvent.MouseScrolled.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseScrolledFromEvent(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseClickedFromEvent(event.getMouseX(), event.getMouseY(), event.getButton())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseReleasedFromEvent(event.getMouseX(), event.getMouseY(), event.getButton())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiInput(ScreenEvent.CharacterTyped.Pre event) {
        Widget<?> focus;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (focus = container.getWindow().getWindowManager() == null ? container.getWindow().getTextFocus() : container.getWindow().getWindowManager().getTextFocus()) != null) {
            event.setCanceled(true);
            container.charTypedFromEvent(event.getCodePoint());
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(ScreenEvent.KeyPressed.Pre event) {
        Widget<?> focus;
        IKeyReceiver container;
        Screen screen = event.getScreen();
        if (screen instanceof IKeyReceiver && (container = (IKeyReceiver)screen).getWindow() != null && (focus = container.getWindow().getWindowManager() == null ? container.getWindow().getTextFocus() : container.getWindow().getWindowManager().getTextFocus()) != null) {
            event.setCanceled(true);
            container.keyTypedFromEvent(event.getKeyCode(), event.getScanCode());
        }
    }

    @SubscribeEvent
    public void onGameRenderOverlay(RenderLevelStageEvent e) {
        if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            DelayedRenderer.render(e.getPoseStack());
        }
    }
}

