/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class NetworkTools {
    public static FluidStack readFluidStack(RegistryFriendlyByteBuf dataIn) {
        FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)dataIn);
        CompoundTag nbt = buf.readNbt();
        return FluidStack.parse((HolderLookup.Provider)dataIn.registryAccess(), (Tag)nbt).orElse(FluidStack.EMPTY);
    }

    public static void writeFluidStack(RegistryFriendlyByteBuf dataOut, FluidStack fluidStack) {
        FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)dataOut);
        CompoundTag nbt = new CompoundTag();
        fluidStack.save((HolderLookup.Provider)dataOut.registryAccess(), (Tag)nbt);
        try {
            buf.writeNbt((Tag)nbt);
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing fluid stack", e);
        }
    }

    public static String readStringUTF8(FriendlyByteBuf dataIn) {
        if (!dataIn.readBoolean()) {
            return null;
        }
        return dataIn.readUtf(Short.MAX_VALUE);
    }

    public static void writeStringUTF8(FriendlyByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeBoolean(false);
            return;
        }
        dataOut.writeBoolean(true);
        dataOut.writeUtf(str);
    }

    public static void writeStringList(FriendlyByteBuf dataOut, @Nonnull List<String> list) {
        dataOut.writeInt(list.size());
        list.forEach(s -> NetworkTools.writeStringUTF8(dataOut, s));
    }

    @Nonnull
    public static List<String> readStringList(FriendlyByteBuf dataIn) {
        int size = dataIn.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(NetworkTools.readStringUTF8(dataIn));
        }
        return list;
    }

    public static ItemStack readItemStack(RegistryFriendlyByteBuf buf) {
        ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        stack.setCount(buf.readInt());
        return stack;
    }

    public static void writeItemStack(RegistryFriendlyByteBuf buf, ItemStack itemStack) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemStack);
        buf.writeInt(itemStack.getCount());
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    @Nonnull
    public static List<ItemStack> readItemStackList(RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(NetworkTools.readItemStack(buf));
        }
        return outputs;
    }

    public static void writeItemStackList(RegistryFriendlyByteBuf buf, @Nonnull List<ItemStack> outputs) {
        buf.writeInt(outputs.size());
        for (ItemStack output : outputs) {
            NetworkTools.writeItemStack(buf, output);
        }
    }

    public static void writeBlockPosList(FriendlyByteBuf dataOut, @Nonnull List<BlockPos> list) {
        dataOut.writeInt(list.size());
        list.forEach(arg_0 -> ((FriendlyByteBuf)dataOut).writeBlockPos(arg_0));
    }

    @Nonnull
    public static List<BlockPos> readBlockPosList(FriendlyByteBuf dataIn) {
        int size = dataIn.readInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(dataIn.readBlockPos());
        }
        return list;
    }
}

