/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.block;

import appeng.block.AEBaseEntityBlock;
import com.mebeamformer.blockentity.OmniBeamFormerBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OmniBeamFormerBlock
extends AEBaseEntityBlock<OmniBeamFormerBlockEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<Status> STATUS = EnumProperty.create((String)"status", Status.class);
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);

    public OmniBeamFormerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue(STATUS, (Comparable)((Object)Status.OFF)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STATUS});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OmniBeamFormerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos, st, be) -> {
            if (be instanceof OmniBeamFormerBlockEntity) {
                OmniBeamFormerBlockEntity bf = (OmniBeamFormerBlockEntity)be;
                if (lvl.isClientSide) {
                    OmniBeamFormerBlockEntity.clientTick(lvl, pos, st, bf);
                } else {
                    OmniBeamFormerBlockEntity.serverTick(lvl, pos, st, bf);
                }
            }
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction face = ctx.getNearestLookingDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face)).setValue(STATUS, (Comparable)((Object)Status.OFF));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return false;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES.get(facing);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES.get(facing);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 15;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return super.useItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            level.blockUpdated(pos, (Block)this);
            for (Direction dir : Direction.values()) {
                level.updateNeighborsAt(pos.relative(dir), (Block)this);
            }
        }
    }

    static {
        for (Direction facing : Direction.values()) {
            SHAPES.put(facing, switch (facing) {
                case Direction.NORTH -> Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)8.0);
                case Direction.SOUTH -> Block.box((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)16.0);
                case Direction.WEST -> Block.box((double)0.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0);
                case Direction.EAST -> Block.box((double)8.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
                case Direction.UP -> Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
                case Direction.DOWN -> Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
                default -> Block.box((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)16.0);
            });
        }
    }

    public static enum Status implements StringRepresentable
    {
        OFF("off"),
        ON("on"),
        BEAMING("beaming");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

