/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.ids.AEComponents;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.blockentity.misc.CellWorkbenchBlockEntity;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.ConfigInventory;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;

public class PortableCellWorkbenchInventory
extends AppEngInternalInventory
implements InternalInventoryHost {
    private final ItemStack stack;
    private final GenericStackInv config = new GenericStackInv(this::onConfigChanged, GenericStackInv.Mode.CONFIG_TYPES, 63);
    private final IConfigManager manager = IConfigManager.builder(this::saveChanges).registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE).build();

    public PortableCellWorkbenchInventory(ItemStack stack) {
        super(null, 1, 1, Filter.FILTER);
        this.stack = stack;
        this.setHost(this);
        this.setEnableClientEvents(true);
        this.fromItemContainerContents((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
        this.config.readFromList((List)stack.getOrDefault(AEComponents.EXPORTED_CONFIG_INV, List.of()));
    }

    ICellWorkbenchItem getCell() {
        ICellWorkbenchItem cell;
        if (this.getStackInSlot(0).isEmpty()) {
            return null;
        }
        Item item = this.getStackInSlot(0).getItem();
        return item instanceof ICellWorkbenchItem ? (cell = (ICellWorkbenchItem)item) : null;
    }

    GenericStackInv getConfig() {
        return this.config;
    }

    IConfigManager getConfigManager() {
        return this.manager;
    }

    private ConfigInventory getCellConfigInventory() {
        ICellWorkbenchItem cell = this.getCell();
        return cell != null ? cell.getConfigInventory(this.getStackInSlot(0)) : null;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        ConfigInventory configInventory = this.getCellConfigInventory();
        if (configInventory != null) {
            if (!configInventory.isEmpty()) {
                CellWorkbenchBlockEntity.copy((GenericStackInv)configInventory, (GenericStackInv)this.config);
            } else {
                CellWorkbenchBlockEntity.copy((GenericStackInv)this.config, (GenericStackInv)configInventory);
                CellWorkbenchBlockEntity.copy((GenericStackInv)configInventory, (GenericStackInv)this.config);
            }
        } else if (this.getConfigManager().getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
            this.config.clear();
        }
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.saveChanges();
    }

    private void onConfigChanged() {
        ConfigInventory c = this.getCellConfigInventory();
        if (c != null) {
            CellWorkbenchBlockEntity.copy((GenericStackInv)this.config, (GenericStackInv)c);
            CellWorkbenchBlockEntity.copy((GenericStackInv)c, (GenericStackInv)this.config);
        }
        this.saveChanges();
    }

    void saveChanges() {
        this.stack.set(DataComponents.CONTAINER, (Object)this.toItemContainerContents());
        this.stack.set(AEComponents.EXPORTED_CONFIG_INV, (Object)this.config.toList());
        this.stack.set(AEComponents.EXPORTED_SETTINGS, (Object)this.manager.exportSettings());
    }

    public boolean isClientSide() {
        return false;
    }

    IUpgradeInventory getCellUpgrades() {
        ICellWorkbenchItem cell = this.getCell();
        return cell != null ? new ProxiedUpgradeInventory(cell.getUpgrades(this.getStackInSlot(0)), this) : UpgradeInventories.empty();
    }

    private static class Filter
    implements IAEItemFilter {
        private static final IAEItemFilter FILTER = new Filter();

        private Filter() {
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return stack.getItem() instanceof ICellWorkbenchItem;
        }
    }

    private static class ProxiedUpgradeInventory
    extends AppEngInternalInventory
    implements IUpgradeInventory {
        private final IUpgradeInventory delegate;

        public ProxiedUpgradeInventory(IUpgradeInventory delegate, InternalInventoryHost host) {
            super(host, delegate.size(), 1);
            this.delegate = delegate;
        }

        public ItemLike getUpgradableItem() {
            return this.delegate.getUpgradableItem();
        }

        public int getInstalledUpgrades(ItemLike u) {
            return this.delegate.getInstalledUpgrades(u);
        }

        public int getMaxInstalled(ItemLike u) {
            return this.delegate.getMaxInstalled(u);
        }

        public void readFromNBT(CompoundTag data, String subtag, HolderLookup.Provider registries) {
            this.delegate.readFromNBT(data, subtag, registries);
        }

        public void writeToNBT(CompoundTag data, String subtag, HolderLookup.Provider registries) {
            this.delegate.writeToNBT(data, subtag, registries);
        }

        public int size() {
            return this.delegate.size();
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return this.delegate.getStackInSlot(slotIndex);
        }

        public void setItemDirect(int slotIndex, ItemStack stack) {
            this.delegate.setItemDirect(slotIndex, stack);
            this.onContentsChanged(slotIndex);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted = this.delegate.extractItem(slot, amount, simulate);
            if (!simulate && !extracted.isEmpty()) {
                this.onContentsChanged(slot);
            }
            return extracted;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.delegate.isItemValid(slot, stack);
        }

        protected boolean eventsEnabled() {
            return true;
        }
    }
}

