/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.mekanismcurios.networking;

import dev.tonimatas.mekanismcurios.bridge.PlayerBridge;
import dev.tonimatas.mekanismcurios.util.CuriosSlots;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.lib.security.ItemSecurityUtils;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record OpenPortableQIOPacket(CuriosSlots slot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenPortableQIOPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mekanismcurios", (String)"portable_qio_packet"));
    public static final StreamCodec<FriendlyByteBuf, OpenPortableQIOPacket> STREAM_CODEC = StreamCodec.composite(CuriosSlots.CURIOS_SLOT_STREAM_CODEC, OpenPortableQIOPacket::slot, OpenPortableQIOPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenPortableQIOPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Item patt0$temp;
            Player player = context.player();
            Level level = player.level();
            ((PlayerBridge)player).mci$setSlot(packet.slot);
            ItemStack stack = packet.slot.getItemStack(player);
            if (!stack.isEmpty() && (patt0$temp = stack.getItem()) instanceof IGuiItem) {
                IGuiItem item = (IGuiItem)patt0$temp;
                ItemSecurityUtils.get().claimOrOpenGui(level, player, null, (arg_0, arg_1, arg_2) -> ((ContainerTypeRegistryObject)item.getContainerType()).tryOpenGui(arg_0, arg_1, arg_2));
            }
        });
    }
}

