/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters.data;

import com.matyrobbrt.mekanisticrouters.MekRouters;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MRItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.parse((String)"item/generated");

    public MRItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "mekanisticrouters", existingFileHelper);
    }

    protected void registerModels() {
        for (DeferredHolder registryObject : MekRouters.ITEMS.getEntries()) {
            Item item;
            String name = registryObject.getId().getPath();
            Objects.requireNonNull((Item)registryObject.get());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleItem.class, UpgradeItem.class, AugmentItem.class}, (Object)item, n)) {
                case 0: {
                    ModuleItem moduleItem = (ModuleItem)item;
                    this.simpleItem((DeferredHolder<Item, ? extends Item>)registryObject, this.modidM("item/module/module_layer0"), this.modidM("item/module/module_layer1"), this.modid("item/module/" + name));
                    break;
                }
                case 1: {
                    UpgradeItem upgradeItem = (UpgradeItem)item;
                    this.simpleItem((DeferredHolder<Item, ? extends Item>)registryObject, this.modidM("item/upgrade/upgrade_layer0"), this.modidM("item/upgrade/upgrade_layer1"), this.modid("item/upgrade/" + name));
                    break;
                }
                case 2: {
                    AugmentItem augmentItem = (AugmentItem)item;
                    this.simpleItem((DeferredHolder<Item, ? extends Item>)registryObject, this.modidM("item/augment/augment_layer0"), this.modid("item/augment/" + name));
                    break;
                }
            }
        }
    }

    private ItemModelBuilder simpleItem(DeferredHolder<Item, ? extends Item> item, String ... textures) {
        return this.simpleItem(item.getId(), textures);
    }

    private ItemModelBuilder simpleItem(ResourceLocation itemKey, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemKey.getPath(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    private String modidM(String path) {
        return "modularrouters:" + path;
    }

    private String modid(String path) {
        return this.modid + ":" + path;
    }
}

