/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import com.mojang.authlib.GameProfile;
import dev.su5ed.mffs.api.card.IdentificationCard;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModDataComponentTypes;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class IdentificationCardItem
extends BaseItem {
    public IdentificationCardItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().stacksTo(1)).description());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(usedHand);
            IdentificationCard card = (IdentificationCard)stack.getCapability(ModCapabilities.IDENTIFICATION_CARD);
            if (!level.isClientSide) {
                if (card.getIdentity() != null) {
                    card.setIdentity(null);
                    player.displayClientMessage((Component)ModUtil.translate("info", "identity_cleared", new Object[0]), true);
                } else {
                    IdentificationCardItem.setCardIdentity(card, player, player.getGameProfile());
                }
            }
            return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public static void onLivingEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (player.isShiftKeyDown() && target instanceof Player) {
            Player targetPlayer = (Player)target;
            IdentificationCard card = (IdentificationCard)stack.getCapability(ModCapabilities.IDENTIFICATION_CARD);
            if (card != null) {
                if (!player.level().isClientSide) {
                    IdentificationCardItem.setCardIdentity(card, player, targetPlayer.getGameProfile());
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
            }
        }
    }

    private static void setCardIdentity(IdentificationCard card, Player user, GameProfile profile) {
        card.setIdentity(profile);
        user.displayClientMessage((Component)ModUtil.translate("info", "identity_set", Component.literal((String)profile.getName()).withStyle(ChatFormatting.GREEN)), true);
    }

    @Override
    protected void appendHoverTextPre(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverTextPre(stack, context, tooltipComponents, isAdvanced);
        IdentificationCard card = (IdentificationCard)stack.getCapability(ModCapabilities.IDENTIFICATION_CARD);
        if (card != null) {
            List<FieldPermission> perms;
            GameProfile identity = card.getIdentity();
            if (identity != null) {
                tooltipComponents.add((Component)ModUtil.translate("info", "identity", Component.literal((String)identity.getName()).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (!(perms = List.copyOf(card.getPermissions())).isEmpty()) {
                MutableComponent permsComponent = ModUtil.translate(perms.getFirst());
                for (int i = 1; i < perms.size(); ++i) {
                    permsComponent.append(", ").append((Component)ModUtil.translate(perms.get(i)));
                }
                tooltipComponents.add((Component)permsComponent.withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public record IdentificationCardAttachment(ItemStack stack) implements IdentificationCard
    {
        private Set<FieldPermission> getPermissionsSet() {
            return new HashSet<FieldPermission>((Collection)this.stack.getOrDefault(ModDataComponentTypes.ID_CARD_PERMISSIONS, List.of()));
        }

        @Override
        public boolean hasPermission(FieldPermission permission) {
            return this.getPermissionsSet().contains((Object)permission);
        }

        @Override
        public void addPermission(FieldPermission permission) {
            Set<FieldPermission> permissions = this.getPermissionsSet();
            permissions.add(permission);
            this.stack.set(ModDataComponentTypes.ID_CARD_PERMISSIONS, List.copyOf(permissions));
        }

        @Override
        public void removePermission(FieldPermission permission) {
            Set<FieldPermission> permissions = this.getPermissionsSet();
            permissions.remove((Object)permission);
            this.stack.set(ModDataComponentTypes.ID_CARD_PERMISSIONS, List.copyOf(permissions));
        }

        @Override
        public Collection<FieldPermission> getPermissions() {
            return this.getPermissionsSet();
        }

        @Override
        public void setPermissions(Collection<FieldPermission> permissions) {
            this.stack.set(ModDataComponentTypes.ID_CARD_PERMISSIONS, List.copyOf(Set.copyOf(permissions)));
        }

        @Override
        @Nullable
        public GameProfile getIdentity() {
            return (GameProfile)this.stack.get(ModDataComponentTypes.ID_CARD_PROFILE);
        }

        @Override
        public void setIdentity(GameProfile profile) {
            this.stack.set(ModDataComponentTypes.ID_CARD_PROFILE, (Object)profile);
        }

        @Override
        public boolean checkIdentity(Player player) {
            GameProfile profile = this.getIdentity();
            return profile == null || player.getGameProfile().equals((Object)profile);
        }

        @Override
        public void copyTo(IdentificationCard other) {
            other.setIdentity(this.getIdentity());
            other.setPermissions(this.getPermissions());
        }
    }
}

