/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CubeProjectorMode
implements ProjectorMode {
    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        int y;
        int x;
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        for (x = -negScale.getX(); x <= posScale.getX(); ++x) {
            for (int z = -negScale.getZ(); z <= posScale.getZ(); ++z) {
                fieldBlocks.add(new Vec3((double)x, (double)posScale.getY(), (double)z));
                fieldBlocks.add(new Vec3((double)x, (double)(-negScale.getY()), (double)z));
            }
        }
        for (x = -negScale.getX(); x <= posScale.getX(); ++x) {
            for (y = -negScale.getY(); y <= posScale.getY(); ++y) {
                fieldBlocks.add(new Vec3((double)x, (double)y, (double)posScale.getZ()));
                fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-negScale.getZ())));
            }
        }
        for (int z = -negScale.getZ(); z <= posScale.getZ(); ++z) {
            for (y = -negScale.getY(); y <= posScale.getY(); ++y) {
                fieldBlocks.add(new Vec3((double)posScale.getX(), (double)y, (double)z));
                fieldBlocks.add(new Vec3((double)(-negScale.getX()), (double)y, (double)z));
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        for (int x = -negScale.getX(); x <= posScale.getX(); ++x) {
            for (int z = -negScale.getZ(); z <= posScale.getZ(); ++z) {
                for (int y = -negScale.getY(); y <= posScale.getY(); ++y) {
                    fieldBlocks.add(new Vec3((double)x, (double)y, (double)z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        BlockPos projectorPos = projector.be().getBlockPos().offset((Vec3i)projector.getTranslation());
        Vec3 relativePosition = position.subtract((double)projectorPos.getX(), (double)projectorPos.getY(), (double)projectorPos.getZ());
        Vec3 rotated = ModUtil.rotateByAngleExact(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch(), -projector.getRotationRoll());
        AABB region = AABB.encapsulatingFullBlocks((BlockPos)projector.getNegativeScale().multiply(-1).offset(1, 1, 1), (BlockPos)projector.getPositiveScale());
        return region.contains(rotated.x(), rotated.y(), rotated.z());
    }
}

