/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.client;

import dev.ftb.mods.mecrh.client.render.EggBombRenderer;
import dev.ftb.mods.mecrh.client.render.EnderChickenRenderer;
import dev.ftb.mods.mecrh.client.sound.ChickenLaserLoop;
import dev.ftb.mods.mecrh.client.sound.ChickenMusicLoop;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.registry.ModEntityTypes;
import dev.ftb.mods.mecrh.registry.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@Mod(value="mecrh", dist={Dist.CLIENT})
public class MECRHModClient {
    public MECRHModClient(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(MECRHModClient::registerRenderers);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntityTypes.ENDER_CHICKEN.get(), ctx -> EnderChickenRenderer.scaled(ctx, 1.6f));
        event.registerEntityRenderer(ModEntityTypes.EGG_BOMB.get(), EggBombRenderer::new);
    }

    public static void playEggBreakEffects(EnderChicken chicken) {
        double eggX = chicken.getX();
        double eggY = chicken.getY() + (double)(chicken.getBbHeight() * 0.6f);
        double eggZ = chicken.getZ();
        Level level = chicken.level();
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DRAGON_EGG.defaultBlockState());
        for (int i = 0; i < 128; ++i) {
            level.addParticle((ParticleOptions)particle, eggX + chicken.getRandom().nextGaussian() * (double)chicken.getBbWidth() * (double)0.15f, eggY + chicken.getRandom().nextGaussian() * (double)chicken.getBbWidth() * (double)0.2f, eggZ + chicken.getRandom().nextGaussian() * (double)chicken.getBbWidth() * (double)0.15f, level.random.nextGaussian() * (double)0.2f, level.random.nextDouble() * 0.4, level.random.nextGaussian() * (double)0.2f);
        }
    }

    public static void startLaserLoopSound(EnderChicken chicken) {
        ChickenLaserLoop sound = new ChickenLaserLoop((SoundEvent)ModSounds.LASER_LOOP.get(), chicken, 0.001f, 1.0f);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }

    public static void startMusicLoop(EnderChicken chicken) {
        ChickenMusicLoop sound = new ChickenMusicLoop((SoundEvent)ModSounds.CHAOS_MUSIC.get(), chicken, 1.0f, 1.0f);
        Minecraft.getInstance().getMusicManager().stopPlaying();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }
}

