/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity;

import dev.ftb.mods.mecrh.ChickenDamageTypes;
import dev.ftb.mods.mecrh.MECRHMod;
import dev.ftb.mods.mecrh.MECRHTags;
import dev.ftb.mods.mecrh.client.MECRHModClient;
import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EggBomb;
import dev.ftb.mods.mecrh.entity.EnderChickenPart;
import dev.ftb.mods.mecrh.entity.ai.ChickenChargeGoal;
import dev.ftb.mods.mecrh.entity.ai.ChickenCluckstormGoal;
import dev.ftb.mods.mecrh.entity.ai.ChickenLaserGoal;
import dev.ftb.mods.mecrh.entity.ai.ChickenSpinGoal;
import dev.ftb.mods.mecrh.entity.ai.ChickenStampedeGoal;
import dev.ftb.mods.mecrh.entity.ai.LookAtTargetGoal;
import dev.ftb.mods.mecrh.event.EnderChickenEvent;
import dev.ftb.mods.mecrh.registry.ModAttachments;
import dev.ftb.mods.mecrh.registry.ModSounds;
import dev.ftb.mods.mecrh.util.ChickenUtils;
import dev.ftb.mods.mecrh.util.PreviousLaserDamage;
import dev.ftb.mods.mecrh.util.Raytracing;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnderChicken
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FLAPPING = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CLEAR_AREA = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FORCEFIELD = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.defineId(EnderChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final RawAnimation LASER_ANIMATION = RawAnimation.begin().thenPlay("attack.laser");
    public static final RawAnimation ENRAGED_ANIMATION = RawAnimation.begin().thenPlay("misc.enraged");
    public static final RawAnimation PECK_ANIMATION = RawAnimation.begin().thenPlay("attack.peck");
    public static final Predicate<? super Entity> PREDICATE_TARGETS = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE).and(e -> !e.isPassenger());
    public static final int SPAWNING_INTRO_TIME = 80;
    public static final ResourceLocation CHICKEN_SCALE_MOD = MECRHMod.id("chicken_scale");
    private static final ResourceLocation RIDER_SCALE_MOD = MECRHMod.id("zombie_rider_scale");
    private static final double ZOMBIE_RIDER_SCALE = 3.0;
    private int abilityInUse;
    private boolean clearAreaNeeded;
    private int firingProgress;
    private boolean inIntroPhase = true;
    private int forcefieldLevel;
    private final Object2LongMap<UUID> forceFieldInformed = new Object2LongOpenHashMap();
    private Zombie zombieRider;
    private int spinTime;
    private int nextSpinTime;
    private int nextChargeTime;
    private int nextPeckTime;
    private int nextStampedeTime;
    private int nextLaserTime;
    private double laserLength;
    private int projectileImmuneTicks;
    private boolean hasCluckstormed;
    private int despawnTimer;
    private ResourceLocation startDim;
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.translatable((String)"entity.mecrh.ender_chicken"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_12);
    private final EnderChickenPart[] subParts;
    public final EnderChickenPart partFootL;
    public final EnderChickenPart partFootR;
    public final EnderChickenPart partLegL;
    public final EnderChickenPart partLegR;
    public final EnderChickenPart partBody;
    public final EnderChickenPart partWingL;
    public final EnderChickenPart partWingR;
    public final EnderChickenPart partHead;
    public final EnderChickenPart partBill;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FLYING_SPEED, 0.25).add(Attributes.MAX_HEALTH, 1024.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 96.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public EnderChicken(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.partFootL = new EnderChickenPart(this, EnderChickenPart.PartType.FOOT_L, 1.25f, 0.125f);
        this.partFootR = new EnderChickenPart(this, EnderChickenPart.PartType.FOOT_R, 1.25f, 0.125f);
        this.partLegL = new EnderChickenPart(this, EnderChickenPart.PartType.LEG_L, 0.5f, 3.0f);
        this.partLegR = new EnderChickenPart(this, EnderChickenPart.PartType.LEG_R, 0.5f, 3.0f);
        this.partBody = new EnderChickenPart(this, EnderChickenPart.PartType.BODY, 3.7f, 3.25f);
        this.partWingL = new EnderChickenPart(this, EnderChickenPart.PartType.WING_L, 2.0f, 2.0f);
        this.partWingR = new EnderChickenPart(this, EnderChickenPart.PartType.WING_R, 2.0f, 2.0f);
        this.partHead = new EnderChickenPart(this, EnderChickenPart.PartType.HEAD, 1.7f, 3.0f);
        this.partBill = new EnderChickenPart(this, EnderChickenPart.PartType.BILL, 1.7f, 1.0f);
        this.subParts = new EnderChickenPart[]{this.partFootL, this.partFootR, this.partLegL, this.partLegR, this.partBody, this.partWingL, this.partWingR, this.partHead, this.partBill};
        this.lookControl = new ChickenLookControl();
        this.startDim = level.dimension().location();
        this.setSizeModifier(-0.975);
    }

    protected PathNavigation createNavigation(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subParts.length; ++i) {
            this.subParts[i].setId(id + i + 1);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subParts;
    }

    public boolean isPickable() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new ChickenStampedeGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ChickenCluckstormGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChickenSpinGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChickenChargeGoal(this, false));
        this.goalSelector.addGoal(3, (Goal)new ChickenChargeGoal(this, true));
        this.goalSelector.addGoal(3, (Goal)new ChickenLaserGoal(this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(5, (Goal)new LookAtTargetGoal(this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (((Boolean)ServerConfig.TARGET_ALL_LIVING.get()).booleanValue()) {
            this.targetSelector.addGoal(2, new ChickenNearestTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, true, e -> !this.isInIntroPhase()));
        } else {
            this.targetSelector.addGoal(2, new ChickenNearestTargetGoal<Player>((Mob)this, Player.class, true, e -> !this.isInIntroPhase()));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FIRING, (Object)false);
        builder.define(CHARGING, (Object)false);
        builder.define(FLAPPING, (Object)false);
        builder.define(CLEAR_AREA, (Object)false);
        builder.define(SPINNING, (Object)false);
        builder.define(FORCEFIELD, (Object)false);
        builder.define(ENRAGED, (Object)false);
    }

    public int getCurrentSwingDuration() {
        return 10;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Primary", 0, this::getPrimaryAnimationState));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)PECK_ANIMATION));
    }

    private PlayState getPrimaryAnimationState(AnimationState<EnderChicken> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        if (this.isFiringLaser()) {
            return state.setAndContinue(LASER_ANIMATION);
        }
        if (this.onGround()) {
            if (state.isMoving()) {
                return state.setAndContinue(ENRAGED_ANIMATION);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }
        if (state.isMoving()) {
            return state.setAndContinue(DefaultAnimations.ATTACK_CHARGE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(2.0);
    }

    public void checkDespawn() {
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount == 81 && this.level().isClientSide && !this.isNoAi()) {
            MECRHModClient.startMusicLoop(this);
        }
        if (this.isSpinning()) {
            if (this.tickCount % 3 == 0) {
                this.spinTime = Math.min(35, this.spinTime + 1);
            }
            this.absRotateTo(this.tickCount * (5 + this.spinTime), this.getXRot());
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        } else {
            this.spinTime = 0;
        }
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.handleLaserFiring();
        this.positionSubparts();
        if (this.isEnraged()) {
            if (!this.level().isClientSide) {
                if (this.level().getGameTime() % 20L == 0L) {
                    this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 2));
                    MobEffectInstance miningFatigue = new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 40, 1);
                    MobEffectUtil.addEffectToPlayersAround((ServerLevel)((ServerLevel)this.level()), (Entity)this, (Vec3)this.position(), (double)8.0, (MobEffectInstance)miningFatigue, (int)40);
                }
            } else {
                Vec3 vec = this.position().add(this.random.nextDouble() * 8.0 - 4.0, 2.0 + this.random.nextDouble() * 6.0, this.random.nextDouble() * 8.0 - 4.0);
                this.level().addParticle((ParticleOptions)(this.random.nextBoolean() ? ParticleTypes.FLAME : ParticleTypes.LAVA), vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void handleLaserFiring() {
        ++this.firingProgress;
        if (this.isFiringLaser()) {
            if (this.firingProgress == 1) {
                this.playSound((SoundEvent)ModSounds.LASER_START.get(), 1.2f, 1.0f);
                if (this.level().isClientSide()) {
                    MECRHModClient.startLaserLoopSound(this);
                }
            } else if (this.firingProgress > 59 && this.firingProgress < 160) {
                HitResult hitResult = Raytracing.getFocusedEntityOrBlock(this, (double)((Integer)ServerConfig.ARENA_RADIUS.get()).intValue() * 2.5);
                if (hitResult instanceof EntityHitResult) {
                    EntityHitResult ehr = (EntityHitResult)hitResult;
                    this.applyLaserEntityDamage(ehr);
                } else if (hitResult instanceof BlockHitResult) {
                    BlockHitResult bhr = (BlockHitResult)hitResult;
                    if (this.level().getGameTime() % 4L == 0L) {
                        this.applyLaserBlockDamage(bhr);
                    }
                }
                this.laserLength = hitResult.getType() == HitResult.Type.MISS ? 16.0 : hitResult.getLocation().distanceTo(this.partBill.position());
            }
        } else if (this.firingProgress > 5) {
            this.firingProgress = -20;
            this.playSound((SoundEvent)ModSounds.LASER_END.get(), 1.2f, 1.0f);
        } else if (this.firingProgress > 0) {
            this.firingProgress = 0;
        }
    }

    private void applyLaserEntityDamage(EntityHitResult ehr) {
        LivingEntity l;
        Entity entity;
        Entity entity2;
        ehr.getEntity().setRemainingFireTicks(((Integer)ServerConfig.LASER_FIRE_TICKS.get()).intValue());
        if (this.isEnraged() && (entity2 = ehr.getEntity()) instanceof LivingEntity) {
            LivingEntity l2 = (LivingEntity)entity2;
            l2.addEffect(new MobEffectInstance(MobEffects.WITHER, ((Integer)ServerConfig.LASER_FIRE_TICKS.get()).intValue(), 1));
        }
        float laserDmg = ((Double)ServerConfig.LASER_DAMAGE.get()).floatValue();
        if (ehr.getEntity().hasData(ModAttachments.PREV_LASER_DMG)) {
            PreviousLaserDamage prevDmg = PreviousLaserDamage.forEntity(ehr.getEntity());
            if (this.level().getGameTime() - prevDmg.when() < 20L) {
                laserDmg = prevDmg.damage() * ((Double)ServerConfig.LASER_DAMAGE_INCREASE.get()).floatValue();
            }
        }
        float effectiveDmg = (entity = ehr.getEntity()) instanceof LivingEntity && (l = (LivingEntity)entity).isBlocking() ? laserDmg * 0.6f : laserDmg;
        ehr.getEntity().hurt(this.level().damageSources().source(ChickenDamageTypes.LASER, (Entity)this), effectiveDmg);
        PreviousLaserDamage.setPreviousLaserDamage(ehr.getEntity(), laserDmg);
    }

    private void applyLaserBlockDamage(BlockHitResult bhr) {
        BlockPos pos = bhr.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (!state.isAir() && state.getDestroySpeed((BlockGetter)this.level(), pos) > 0.0f && !state.is(MECRHTags.Blocks.CHICKEN_UNBREAKABLE)) {
            ChickenUtils.destroyBlock((Entity)this, pos);
            for (Direction dir : Direction.values()) {
                BlockPos pos2 = pos.relative(dir);
                if (!(this.random.nextFloat() < 0.5f) || state.isAir() || !(state.getDestroySpeed((BlockGetter)this.level(), pos2) > 0.0f) || state.is(MECRHTags.Blocks.CHICKEN_UNBREAKABLE)) continue;
                ChickenUtils.destroyBlock((Entity)this, pos);
            }
            Vec3 vec = Vec3.atCenterOf((Vec3i)bhr.getBlockPos().relative(bhr.getDirection()));
            this.level().explode((Entity)this, vec.x, vec.y, vec.z, 2.0f, Level.ExplosionInteraction.NONE);
        }
    }

    protected void customServerAiStep() {
        if (!this.hasRestriction()) {
            this.restrictTo(this.blockPosition(), (Integer)ServerConfig.ARENA_RADIUS.get());
        }
        if (this.isInIntroPhase() && this.tickCount < 80) {
            int halfIntroTime = 40;
            if (this.tickCount <= halfIntroTime) {
                this.setSizeModifier(-0.975);
                if (this.tickCount % 20 == 5) {
                    this.playSound(SoundEvents.CHICKEN_AMBIENT);
                }
                this.bossEvent.setProgress(0.0f);
            } else {
                this.setSizeModifier((double)(80 - this.tickCount) / (double)(-halfIntroTime));
                if (this.tickCount % 7 == 0) {
                    this.playSound(SoundEvents.CHICKEN_AMBIENT, 1.0f, 0.6f + (float)this.tickCount / 80.0f);
                }
                this.bossEvent.setProgress((float)(this.tickCount - halfIntroTime) / (float)halfIntroTime);
            }
        } else {
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
        if (this.tickCount == 1) {
            if (!this.inIntroPhase && !this.hasPassenger(e -> e.getType() == EntityType.ZOMBIE)) {
                this.spawnZombieRider(true);
            }
        } else if (this.tickCount == 60) {
            if (this.inIntroPhase && !this.hasPassenger(e -> e.getType() == EntityType.ZOMBIE)) {
                this.spawnZombieRider(false);
            }
        } else if (this.isInIntroPhase()) {
            if (this.tickCount == 80) {
                this.nextSpinTime = this.tickCount + ServerConfig.getSpinInterval(this.getRandom());
                this.nextChargeTime = this.tickCount + ServerConfig.getChargeInterval(this.getRandom());
                this.nextPeckTime = this.tickCount + ServerConfig.getPeckInterval(this.getRandom());
                this.nextLaserTime = this.tickCount + ServerConfig.getLaserInterval(this.getRandom());
                this.nextStampedeTime = 0;
                this.playSound(SoundEvents.BELL_BLOCK, 2.0f, 0.6f);
                this.setForceField(true);
                this.inIntroPhase = false;
                ChickenUtils.postChickenEvent(this, EnderChickenEvent.Phase.SHIELDED_ENTRY);
            } else if (this.tickCount == 90) {
                this.playSound(SoundEvents.CHICKEN_HURT, 2.0f, 0.7f);
            }
        }
        if (this.forcefieldLevel < 0 && ++this.forcefieldLevel == 0) {
            this.setForceField(true);
        }
        if (this.zombieRider != null) {
            this.updateZombieRider();
        }
        if (this.getHealth() < this.getMaxHealth() * 0.15f && !this.isEnraged()) {
            this.setEnraged();
        }
        if (this.projectileImmuneTicks > 0) {
            --this.projectileImmuneTicks;
        }
        if (this.hasRestriction() && this.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.getRestrictCenter())) > (double)ServerConfig.getArenaRadiusSq() && this.level().dimension().location().equals((Object)this.startDim)) {
            Vec3 dest = Vec3.atBottomCenterOf((Vec3i)this.getRestrictCenter());
            this.teleportTo(dest.x, dest.y, dest.z);
            this.setProjectileImmuneTicks(40);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 10, (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0, 0.1);
                this.playSound(SoundEvents.ENDERMAN_TELEPORT);
            }
        }
        if (this.tickCount % 20 == 0 && (Integer)ServerConfig.DESPAWN_TIME_NO_PLAYERS.get() > 0) {
            if (this.countPlayersInArena() == 0) {
                if (this.despawnTimer % 5 == 0) {
                    AABB aabb = new AABB(this.blockPosition()).inflate((double)((Integer)ServerConfig.ARENA_RADIUS.get() * 2));
                    int timer = (Integer)ServerConfig.DESPAWN_TIME_NO_PLAYERS.get() - this.despawnTimer;
                    MutableComponent msg = Component.translatable((String)"mecrh.message.chicken_despawn_warning", (Object[])new Object[]{timer}).withStyle(ChatFormatting.GOLD);
                    this.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, aabb).forEach(arg_0 -> EnderChicken.lambda$customServerAiStep$5((Component)msg, arg_0));
                }
                if (++this.despawnTimer >= (Integer)ServerConfig.DESPAWN_TIME_NO_PLAYERS.get()) {
                    this.getPassengers().forEach(Entity::discard);
                    this.discard();
                    MECRHMod.LOGGER.info("Despawned ender chicken id {} @ {}, no players in arena for 30 seconds", (Object)this.getId(), (Object)this.blockPosition());
                }
            } else {
                this.despawnTimer = 0;
            }
        }
    }

    private void spawnZombieRider(boolean immediate) {
        this.zombieRider = new Zombie(this.level());
        this.zombieRider.setBaby(true);
        this.zombieRider.setPos(this.position().add(0.0, (double)((Integer)ServerConfig.ZOMBIE_RIDER_SPAWN_HEIGHT.get()).intValue(), 0.0));
        this.zombieRider.setXRot(this.getXRot());
        this.zombieRider.setYRot(this.getYRot());
        this.zombieRider.setInvulnerable(true);
        this.zombieRider.setSilent(true);
        AttributeInstance scaleAttr = this.zombieRider.getAttribute(Attributes.SCALE);
        if (scaleAttr != null) {
            scaleAttr.addPermanentModifier(new AttributeModifier(RIDER_SCALE_MOD, 3.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.level().addFreshEntity((Entity)this.zombieRider);
        if (immediate) {
            this.zombieRider.setNoAi(true);
            this.zombieRider.startRiding((Entity)this);
        }
    }

    private void updateZombieRider() {
        if (this.zombieRider.getVehicle() == null) {
            if (this.zombieRider.distanceToSqr(this.getPassengerRidingPosition((Entity)this)) < 4.0) {
                this.zombieRider.setNoAi(true);
                this.zombieRider.startRiding((Entity)this);
            } else {
                this.zombieRider.setPos(this.position().x, this.zombieRider.position().y, this.position().z);
            }
        }
        this.zombieRider.setYRot(this.getYRot());
        this.zombieRider.setXRot(this.getXRot());
        this.zombieRider.setYHeadRot(this.getYHeadRot());
        this.zombieRider.setRemainingFireTicks(0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 1) {
            if (this.level().isClientSide()) {
                AABB aabb = new AABB(this.blockPosition()).inflate((double)((Integer)ServerConfig.ARENA_RADIUS.get()).intValue());
                this.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, aabb).forEach(player -> player.playSound(SoundEvents.ENDER_DRAGON_DEATH));
            } else {
                ChickenUtils.postChickenEvent(this, EnderChickenEvent.Phase.DEATH_SEQUENCE);
            }
        } else if (this.deathTime == 10 && !this.level().isClientSide()) {
            BlockPos pos = Objects.requireNonNullElse(this.getRestrictCenter(), this.blockPosition());
            AABB aabb = new AABB(pos).inflate((double)((Integer)ServerConfig.ARENA_RADIUS.get() * 2));
            this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.forNonCombat(), (LivingEntity)this, aabb).forEach(entity -> {
                if (ChickenUtils.hasChickenBoss((Entity)entity, this)) {
                    entity.kill();
                }
            });
        }
        if (this.deathTime == 10 && !this.level().isClientSide()) {
            this.getPassengers().forEach(Entity::discard);
            this.zombieRider = null;
        }
        if (this.deathTime < 80 && this.level().isClientSide()) {
            Vec3 vec = this.position().add(this.random.nextDouble() * 8.0 - 4.0, 2.0 + this.random.nextDouble() * 6.0, this.random.nextDouble() * 8.0 - 4.0);
            this.level().addParticle((ParticleOptions)(this.random.nextBoolean() ? ParticleTypes.FLAME : ParticleTypes.ASH), vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
            CampfireBlock.makeParticles((Level)this.level(), (BlockPos)this.blockPosition().above(3), (boolean)false, (boolean)true);
            if (this.deathTime % 5 == 0) {
                double x = this.getBoundingBox().minX + this.random.nextDouble() * this.getBoundingBox().getXsize();
                double y = this.getBoundingBox().minY + this.random.nextDouble() * this.getBoundingBox().getYsize();
                double z = this.getBoundingBox().minZ + this.random.nextDouble() * this.getBoundingBox().getZsize();
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (this.deathTime >= 80 && !this.level().isClientSide()) {
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent((Holder)GameEvent.ENTITY_DIE);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("ForceFieldLevel", this.forcefieldLevel);
        compound.putInt("NextSpinTime", this.nextSpinTime - this.tickCount);
        compound.putInt("NextChargeTime", this.nextChargeTime - this.tickCount);
        compound.putInt("NextPeckTime", this.nextPeckTime - this.tickCount);
        compound.putInt("NextLaserTime", this.nextLaserTime - this.tickCount);
        if (this.inIntroPhase) {
            compound.putBoolean("IntroPhase", true);
        }
        if (this.projectileImmuneTicks > 0) {
            compound.putInt("ProjectileImmuneTicks", this.projectileImmuneTicks);
        }
        if (this.hasRestriction()) {
            compound.put("RestrictPos", NbtUtils.writeBlockPos((BlockPos)this.getRestrictCenter()));
        }
        if (this.isEnraged()) {
            compound.putBoolean("Enraged", true);
        }
        if (this.hasCluckstormed) {
            compound.putBoolean("HasCluckstormed", true);
        }
        compound.putString("StartDim", this.startDim.toString());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.forcefieldLevel = compound.getInt("ForceFieldLevel");
        this.setForceField(this.forcefieldLevel > 0, false);
        this.nextSpinTime = compound.getInt("NextSpinTime");
        this.nextChargeTime = compound.getInt("NextChargeTime");
        this.nextPeckTime = compound.getInt("NextPeckTime");
        this.nextLaserTime = compound.getInt("NextLaserTime");
        this.inIntroPhase = compound.getBoolean("IntroPhase");
        this.projectileImmuneTicks = compound.getInt("ProjectileImmuneTicks");
        this.hasCluckstormed = compound.getBoolean("HasCluckstormed");
        NbtUtils.readBlockPos((CompoundTag)compound, (String)"RestrictPos").ifPresent(pos -> this.restrictTo((BlockPos)pos, (Integer)ServerConfig.ARENA_RADIUS.get()));
        this.entityData.set(ENRAGED, (Object)compound.getBoolean("Enraged"));
        if (!this.inIntroPhase) {
            this.setSizeModifier(1.0);
        }
        try {
            this.startDim = ResourceLocation.parse((String)compound.getString("StartDim"));
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        int a = Math.abs(this.swingTime - this.getCurrentSwingDuration() / 2);
        double yOff = 2.25 + (this.swinging ? (double)a / (double)this.getCurrentSwingDuration() : 0.0);
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).subtract(0.0, yOff, 0.0);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isForceField()) {
            if (this.attackerCanBreakForcefield(source.getEntity())) {
                this.playSound((SoundEvent)ModSounds.CHAOS_HURT.get());
                if (!this.level().isClientSide() && --this.forcefieldLevel <= 0) {
                    this.setForceField(false);
                    this.playSound(SoundEvents.SHIELD_BREAK);
                }
            } else {
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.hurt(source, amount);
                    long delta = this.level().getGameTime() - this.forceFieldInformed.getOrDefault((Object)player.getUUID(), 0L);
                    if (delta > 100L) {
                        player.displayClientMessage((Component)Component.translatable((String)"mecrh.message.wrong_forcefield_item"), true);
                        this.forceFieldInformed.put((Object)player.getUUID(), this.level().getGameTime());
                    }
                }
            }
            return false;
        }
        if (this.shouldIgnoreDamage(source)) {
            return false;
        }
        if (source.is(DamageTypes.IN_WALL)) {
            this.clearAreaNeeded = true;
            return false;
        }
        if (!source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            amount = Math.min(amount, (float)((Integer)ServerConfig.MAX_INCOMING_DAMAGE.get()).intValue() * (this.isEnraged() ? 0.3f : 1.0f));
        }
        return super.hurt(source, amount);
    }

    public float maxUpStep() {
        return 2.0f;
    }

    public boolean attackFromPart(DamageSource source, EnderChickenPart part, float amount) {
        return this.hurt(source, amount);
    }

    private boolean attackerCanBreakForcefield(Entity entity) {
        LivingEntity l;
        boolean bl = ((Boolean)ServerConfig.NON_PLAYERS_IGNORE_SHIELD.get()).booleanValue() ? !(entity instanceof Player) : entity instanceof LivingEntity && (l = (LivingEntity)entity).getMainHandItem().is(MECRHTags.Items.CHICKEN_STICKS);
        return bl;
    }

    private boolean inIntroPhase() {
        return this.tickCount < 80;
    }

    public boolean shouldIgnoreDamage(DamageSource source) {
        return source.is(DamageTypes.DRAGON_BREATH) || source.getEntity() == this || source.getEntity() instanceof EnderChicken || this.isProjectileImmune() && (source.getDirectEntity() instanceof AbstractArrow || source.getDirectEntity() instanceof WindCharge) || this.inIntroPhase();
    }

    public boolean isProjectileImmune() {
        return this.projectileImmuneTicks > 0 || this.isFiringLaser() || this.isSpinning();
    }

    public void setProjectileImmuneTicks(int immuneTicks) {
        this.projectileImmuneTicks = immuneTicks;
    }

    private void positionSubparts() {
        Vec3[] prevPartPos = new Vec3[this.subParts.length];
        for (int i = 0; i < this.subParts.length; ++i) {
            prevPartPos[i] = new Vec3(this.subParts[i].getX(), this.subParts[i].getY(), this.subParts[i].getZ());
        }
        float yawRad = this.yBodyRot * ((float)Math.PI / 180);
        float xOff = Mth.cos((float)yawRad);
        float zOff = Mth.sin((float)yawRad);
        float headYawRad = this.yHeadRot * ((float)Math.PI / 180) + 1.5707964f;
        float headPitchRad = this.lerpTargetXRot() * ((float)Math.PI / 180);
        float xOffHead = Mth.cos((float)(yawRad + 1.5707964f));
        float zOffHead = Mth.sin((float)(yawRad + 1.5707964f));
        float yOffHead = -Mth.sin((float)headPitchRad);
        float distOffHead = Mth.sin((float)headPitchRad) / 2.0f;
        this.updatePartPos(this.partFootL, xOff * 0.8f, 0.0f, zOff * 0.8f);
        this.updatePartPos(this.partFootR, xOff * -0.8f, 0.0f, zOff * -0.8f);
        this.updatePartPos(this.partLegL, xOff * 0.7f, 0.125f, zOff * 0.7f);
        this.updatePartPos(this.partLegR, xOff * -0.7f, 0.125f, zOff * -0.7f);
        this.updatePartPos(this.partBody, xOff * 0.0f, 2.5f, zOff * 0.0f);
        this.updatePartPos(this.partWingL, xOff * 2.0f, 3.5f, zOff * 2.0f);
        this.updatePartPos(this.partWingR, xOff * -2.0f, 3.5f, zOff * -2.0f);
        this.updatePartPos(this.partHead, xOffHead * (2.0f + distOffHead), 4.5f + yOffHead, zOffHead * (2.0f + distOffHead));
        Vec3 headPos = this.partHead.position();
        this.partBill.setPos(headPos.x + (double)Mth.cos((float)headYawRad), headPos.y + 1.0, headPos.z + (double)Mth.sin((float)headYawRad));
        for (int i = 0; i < this.subParts.length; ++i) {
            this.subParts[i].xo = prevPartPos[i].x;
            this.subParts[i].yo = prevPartPos[i].y;
            this.subParts[i].zo = prevPartPos[i].z;
            this.subParts[i].xOld = prevPartPos[i].x;
            this.subParts[i].yOld = prevPartPos[i].y;
            this.subParts[i].zOld = prevPartPos[i].z;
        }
    }

    private void updatePartPos(EnderChickenPart part, float xOff, float yOff, float zOff) {
        part.setPos(this.getX() + (double)xOff, this.getY() + (double)yOff, this.getZ() + (double)zOff);
    }

    public boolean canUseAbility() {
        return !this.inIntroPhase() && this.isAlive() && this.abilityInUse < (Integer)ServerConfig.MAX_SKILLS_AT_ONCE.get();
    }

    public void useAbility() {
        ++this.abilityInUse;
    }

    public void endAbility() {
        --this.abilityInUse;
    }

    public boolean isInIntroPhase() {
        return this.inIntroPhase;
    }

    public boolean isCharging() {
        return (Boolean)this.getEntityData().get(CHARGING);
    }

    public void setCharging(boolean charging, boolean peckOfDoom) {
        this.getEntityData().set(CHARGING, (Object)charging);
        if (!charging) {
            if (peckOfDoom) {
                this.nextPeckTime = this.tickCount + ServerConfig.getPeckInterval(this.getRandom());
            } else {
                this.nextChargeTime = this.tickCount + ServerConfig.getChargeInterval(this.getRandom());
            }
        }
    }

    public boolean isClearingArea() {
        return (Boolean)this.getEntityData().get(CLEAR_AREA);
    }

    public void setClearingArea(boolean clearing) {
        this.getEntityData().set(CLEAR_AREA, (Object)clearing);
    }

    public boolean isFiringLaser() {
        return (Boolean)this.getEntityData().get(FIRING);
    }

    public void setFiringLaser(boolean firing) {
        if (firing && !this.isFiringLaser()) {
            this.firingProgress = 0;
        }
        this.getEntityData().set(FIRING, (Object)firing);
        if (!firing) {
            this.nextLaserTime = this.tickCount + ServerConfig.getLaserInterval(this.getRandom());
        }
    }

    public boolean isFlapping() {
        return (Boolean)this.getEntityData().get(FLAPPING);
    }

    public void setFlapping(boolean flapping) {
        this.getEntityData().set(FLAPPING, (Object)flapping);
    }

    public boolean isForceField() {
        return (Boolean)this.getEntityData().get(FORCEFIELD);
    }

    public void setForceField(boolean forcefield) {
        this.setForceField(forcefield, true);
    }

    public void setForceField(boolean forcefield, boolean postEvent) {
        if (forcefield != this.isForceField()) {
            this.getEntityData().set(FORCEFIELD, (Object)forcefield);
            this.forcefieldLevel = forcefield ? (Integer)ServerConfig.FORCEFIELD_LEVEL.get() : -((Integer)ServerConfig.FORCEFIELD_INTERVAL.get()).intValue();
            this.playSound(forcefield ? (SoundEvent)ModSounds.FF_ON.get() : (SoundEvent)ModSounds.FF_OFF.get(), 1.5f, 1.0f);
            if (postEvent) {
                ChickenUtils.postChickenEvent(this, forcefield ? EnderChickenEvent.Phase.SHIELD_CYCLE : EnderChickenEvent.Phase.VULNERABLE_ASSAULT);
            }
        }
    }

    public boolean isSpinning() {
        return (Boolean)this.getEntityData().get(SPINNING);
    }

    public void setSpinning(boolean spinning) {
        this.getEntityData().set(SPINNING, (Object)spinning);
        this.setYBodyRot(this.getYHeadRot());
        if (!spinning) {
            this.nextSpinTime = this.tickCount + ServerConfig.getSpinInterval(this.getRandom());
        }
    }

    public int getFiringProgress() {
        return this.firingProgress;
    }

    public void scheduleNextStampede() {
        this.nextStampedeTime = this.tickCount + ServerConfig.getStampedeInterval(this.getRandom());
    }

    public void setEnraged() {
        this.entityData.set(ENRAGED, (Object)true);
        this.playSound(SoundEvents.CHICKEN_DEATH, 1.0f, 0.5f);
        ChickenUtils.postChickenEvent(this, EnderChickenEvent.Phase.ENRAGE);
    }

    public boolean isEnraged() {
        return (Boolean)this.entityData.get(ENRAGED);
    }

    public void explode(double x, double y, double z, float strength, boolean fire, boolean damageTerrain) {
        if (!this.level().isClientSide) {
            Explosion.BlockInteraction blockInteraction = damageTerrain ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
            Explosion explosion = new Explosion(this.level(), (Entity)this, x, y, z, strength, fire, blockInteraction);
            if (EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion)) {
                return;
            }
            explosion.explode();
            explosion.finalizeExplosion(false);
            if (!damageTerrain) {
                explosion.clearToBlow();
            }
            this.level().players().forEach(player -> {
                ServerPlayer sp;
                if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).distanceToSqr(x, y, z) < 4096.0) {
                    sp.connection.send((Packet)new ClientboundExplodePacket(x, y, z, strength, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(player), blockInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION, (Holder)SoundEvents.GENERIC_EXPLODE));
                }
            });
        }
    }

    public void resetShouldClearArea() {
        this.clearAreaNeeded = false;
    }

    public boolean shouldClearArea() {
        if (this.clearAreaNeeded) {
            this.clearAreaNeeded = false;
            return true;
        }
        return this.partInWall(this.partHead) || this.partInWall(this.partWingL) || this.partInWall(this.partWingR);
    }

    private boolean partInWall(EnderChickenPart part) {
        float width = part.getBbWidth() * 0.8f;
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            int x = Mth.floor((double)(part.getX() + ((double)((i >> 1) % 2) - 0.5) * (double)width * 0.8));
            int y = Mth.floor((double)(part.getY() + ((double)((i >> 0) % 2) - 0.5) * 0.1 + (double)part.getBbHeight() * 0.8));
            int z = Mth.floor((double)(part.getZ() + ((double)((i >> 2) % 2) - 0.5) * (double)width * 0.8));
            if (mutPos.getX() == x && mutPos.getY() == y && mutPos.getZ() == z) continue;
            mutPos.set(x, y, z);
            if (!this.level().getBlockState((BlockPos)mutPos).isSuffocating((BlockGetter)this.level(), (BlockPos)mutPos)) continue;
            return true;
        }
        return false;
    }

    public Vec3 getHeadPos(double horiOffset, double vertOffset) {
        float scale = this.getScale();
        float ryoSin = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
        float ryoCos = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
        return new Vec3(this.getX() - (double)ryoSin * horiOffset * (double)scale, this.getEyeY() + vertOffset * (double)scale, this.getZ() + (double)ryoCos * horiOffset * (double)scale);
    }

    public void launchEggBomb(float speed, boolean huntTarget) {
        float scale = this.getScale();
        Vec3 launchPos = this.getHeadPos(-3.5, -2.0);
        EggBomb egg = new EggBomb(this.level(), (LivingEntity)this);
        egg.huntTarget(huntTarget);
        egg.setPos(launchPos);
        egg.shootFromRotation((Entity)this, 0.0f, this.getYRot() - 180.0f, 0.0f, speed, 1.0f);
        this.playSound(SoundEvents.CHICKEN_EGG, 1.0f + 0.2f * scale, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f);
        this.level().addFreshEntity((Entity)egg);
    }

    public boolean isSpinReady() {
        return this.tickCount >= this.nextSpinTime;
    }

    public boolean isChargeReady(boolean peckOfDoom) {
        return this.tickCount >= (peckOfDoom ? this.nextPeckTime : this.nextChargeTime);
    }

    public boolean isStampedeReady() {
        return this.tickCount >= this.nextStampedeTime;
    }

    public boolean isLaserReady(boolean targetAbove) {
        return this.tickCount >= this.nextLaserTime - (targetAbove ? 40 : 0);
    }

    private void setSizeModifier(double modifier) {
        AttributeInstance attr = this.getAttribute(Attributes.SCALE);
        if (attr != null) {
            attr.removeModifier(CHICKEN_SCALE_MOD);
            if (modifier != 1.0) {
                attr.addTransientModifier(new AttributeModifier(CHICKEN_SCALE_MOD, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
        }
    }

    public double getLaserLength() {
        return this.laserLength;
    }

    public boolean hasCluckstormed() {
        return this.hasCluckstormed;
    }

    public void setHasCluckstormed() {
        this.hasCluckstormed = true;
    }

    private int countPlayersInArena() {
        AABB aabb = new AABB(this.blockPosition()).inflate((double)((Integer)ServerConfig.ARENA_RADIUS.get() + 2));
        return (int)this.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, aabb).stream().filter(this::isInArena).count();
    }

    public boolean isInArena(Entity entity) {
        return !this.hasRestriction() || this.getRestrictCenter().distToCenterSqr(entity.getX(), entity.getY(), entity.getZ()) < (double)ServerConfig.getArenaRadiusSq();
    }

    private static /* synthetic */ void lambda$customServerAiStep$5(Component msg, Player player) {
        player.displayClientMessage(msg, false);
    }

    private class ChickenLookControl
    extends LookControl {
        public ChickenLookControl() {
            super((Mob)EnderChicken.this);
        }

        protected boolean resetXRotOnTick() {
            return !EnderChicken.this.isFiringLaser();
        }

        public void tick() {
            if (!EnderChicken.this.isSpinning()) {
                super.tick();
            }
        }
    }

    private static class ChickenNearestTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public ChickenNearestTargetGoal(Mob mob, Class<T> targetType, boolean mustSee, Predicate<LivingEntity> targetPredicate) {
            super(mob, targetType, mustSee, targetPredicate);
        }

        public boolean canUse() {
            return super.canUse() && !((EnderChicken)this.mob).isInIntroPhase() && this.target != null && !this.target.getType().is(MECRHTags.Entities.CHICKEN_FRIENDS);
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            return this.mob.getBoundingBox().inflate(targetDistance, 16.0, targetDistance);
        }
    }
}

