/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import dev.ftb.mods.mecrh.registry.ModSounds;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;

public class ClearAreaGoal
extends ChickenGoal {
    private int clearingAreaTime;

    public ClearAreaGoal(EnderChicken chicken) {
        super(chicken);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean canUse() {
        return this.chicken.canUseAbility() && this.chicken.shouldClearArea();
    }

    public boolean canContinueToUse() {
        return this.chicken.isClearingArea() && this.chicken.isAlive();
    }

    public void start() {
        this.chicken.useAbility();
        this.chicken.setClearingArea(true);
        this.clearingAreaTime = 0;
    }

    public void stop() {
        this.chicken.endAbility();
        this.clearingAreaTime = 0;
    }

    public void tick() {
        if (!this.chicken.isFiringLaser()) {
            this.chicken.setXRot(20.0f);
        }
        ++this.clearingAreaTime;
        if (this.clearingAreaTime == 1) {
            this.chicken.playSound((SoundEvent)ModSounds.CLEAR_WARN.get(), 1.0f + 0.2f * this.chicken.getScale(), 0.8f + this.chicken.getRandom().nextFloat() * 0.4f);
        } else if (this.clearingAreaTime == 40) {
            this.chicken.explode(this.chicken.partHead.getX(), this.chicken.partHead.getY(), this.chicken.partHead.getZ(), 3.75f * this.chicken.getScale(), false, true);
            this.chicken.explode(this.chicken.getX(), this.chicken.getY(), this.chicken.getZ(), 8.5f * this.chicken.getScale(), false, true);
        } else if (this.clearingAreaTime >= 55) {
            this.chicken.resetShouldClearArea();
            this.chicken.setClearingArea(false);
        }
    }
}

